/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.saveInstruct;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.dto.GetRechargeDataDto;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.pour.SaveTemplatePour;
import com.aote.webmeter.common.template.saveInstruct.BasicSaveInstructTemplate;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.SaleTypeEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.SpringBeanUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Template
public class SaveGasRechargeInstructTemplate
extends BasicSaveInstructTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveGasRechargeInstructTemplate.class);
    private GetRechargeDataDto dto;
    private SaveTemplatePour saveTemplatePour;
    private Boolean isSyncBalance;

    protected SaveGasRechargeInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao) {
        super(instructManage, userFilesDao, saleDataDao, changeMeterDataDao);
    }

    @Override
    protected void beforeExec() {
        this.userId = this.dto.getUserId();
        this.type = this.isSyncBalance != false ? InstructTypeEnum.ChargeMeter : InstructTypeEnum.GasRecharge;
        this.content = JsonHelper.toJSON((Object)this.saveTemplatePour.run(this.dto));
        this.inputtor = InstructInputtorEnum.CHARGE;
        this.title = this.dto.getType().getValue();
        this.dataId = this.dto.getId();
    }

    @Override
    protected void afterExec() {
        SaleTypeEnum saleTypeEnum = this.dto.getType();
        switch (saleTypeEnum) {
            case CHARGE: 
            case REFUND: 
            case CHARGE_OR_REFUND: {
                this.saleDataDao.updateSellingGasSyncState(this.dto.getId());
                break;
            }
            case CANCEL_CHARGE: {
                this.saleDataDao.updateCancelSellingGasSyncState(this.dto.getId());
                break;
            }
            case ADD_FEE: 
            case SUB_FEE: 
            case ADD_OR_SUB_FEE: {
                this.saleDataDao.updateAdjustMoneySyncState(this.dto.getId());
                break;
            }
            case REPLACE_METER_ADD_VOLUME: {
                this.saleDataDao.updateSupplyGasSyncState(this.dto.getId());
                break;
            }
            default: {
                throw new WebmeterException(BusinessExceptionCodeEnum.INVALID_RECHARGE_SOURCE_TYPE);
            }
        }
    }

    public static class Builder
    extends AbstractTemplateBuilder {
        private final SaveGasRechargeInstructTemplate template = SpringBeanUtil.getBean(SaveGasRechargeInstructTemplate.class);

        public Builder(GetRechargeDataDto dto, SaveTemplatePour saveTemplatePour) {
            this.template.dto = dto;
            this.template.saveTemplatePour = saveTemplatePour;
        }

        @Override
        public SaveGasRechargeInstructTemplate build() {
            this.template.isSyncBalance = Optional.ofNullable(this.template.isSyncBalance).orElse(false);
            return this.template;
        }

        public Builder moduleName(String moduleName) {
            this.template.moduleName = moduleName;
            return this;
        }

        public Builder isSyncBalance(Boolean isSyncBalance) {
            this.template.isSyncBalance = isSyncBalance;
            return this;
        }
    }
}

