/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage.param.instructmanage;

import com.aote.webmeter.common.basic.manage.param.AbstractParam;
import com.aote.webmeter.common.basic.manage.param.AbstractParamBuilder;
import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.common.utils.NecessaryValue;
import com.aote.webmeter.enums.business.InstructStateEnum;
import java.util.Optional;
import javax.validation.constraints.NotNull;

public class SetInstructStateParam
extends AbstractParam {
    private NecessaryValue<String, Condition> id;
    private NecessaryValue<String, Condition> commandId;
    private NecessaryValue<Condition, Condition> condition;
    private InstructStateEnum state;
    private String metaData;
    private String receiveMsg;
    private String syncCommandId;

    private SetInstructStateParam() {
    }

    public Condition getCondition() {
        return this.condition.getOutValue();
    }

    public NecessaryValue<String, Condition> getId() {
        return this.id;
    }

    public NecessaryValue<String, Condition> getCommandId() {
        return this.commandId;
    }

    public InstructStateEnum getState() {
        return this.state;
    }

    public String getMetaData() {
        return this.metaData;
    }

    public String getReceiveMsg() {
        return this.receiveMsg;
    }

    public String getSyncCommandId() {
        return this.syncCommandId;
    }

    public static class Builder
    extends AbstractParamBuilder {
        private final SetInstructStateParam param = new SetInstructStateParam();

        public Builder(@NotNull InstructStateEnum stateEnum) {
            this.param.state = stateEnum;
        }

        @Override
        public SetInstructStateParam build() {
            this.param.condition = this.checkAndGetNecessaryParams(this.param);
            this.param.receiveMsg = Optional.ofNullable(this.param.receiveMsg).orElseGet(() -> this.param.state.getReceiveMsg());
            this.param.metaData = Optional.ofNullable(this.param.metaData).orElse("@isnull(f_instruct_meta_data,f_instruct_content)");
            this.param.syncCommandId = Optional.ofNullable(this.param.syncCommandId).orElse("@isnull(f_commandId,id)");
            return this.param;
        }

        public Builder id(String id) {
            this.param.id = new NecessaryValue<String, Condition>(1, id, () -> Condition.build().eq("id", id));
            return this;
        }

        public Builder commandId(String commandId) {
            this.param.commandId = new NecessaryValue<String, Condition>(2, commandId, () -> Condition.build().eq("f_commandId", commandId));
            return this;
        }

        public Builder condition(Condition condition) {
            this.param.condition = new NecessaryValue(3, condition);
            return this;
        }

        public Builder metaData(String metaData) {
            this.param.metaData = metaData;
            return this;
        }

        public Builder receiveMsg(String receiveMsg) {
            this.param.receiveMsg = receiveMsg;
            return this;
        }

        public Builder syncCommandId(String syncCommandId) {
            this.param.syncCommandId = syncCommandId;
            return this;
        }
    }
}

