package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 指令类型
 * @author Mr.river
 */
public enum InstructTypeEnum {
    OpenAccount("远程开户"),
    Initialization("初始化"),
    ChangeMeter("远程注销"),
    GasRecharge("远程充值"),
    SetPrice("远程调价"),
    ChargeMeter("余额同步"),
    ValveControl("阀门控制"),
    SetParams("设置参数"),
    ReadParams("读取参数"),
    SyncAreas("同步区域"),
    SyncAddress("同步地址"),
    SyncPriceType("同步气价类型"),
    DetailPrice("同步气价计划"),
    SyncFiles("同步气表档案"),
    HandPlan("远程抄表"),
    SetTime("远程校时"),
    SetIP("设置IP"),
    CloseConnection("结束下发"),
    Safeguard("远程维护"),
    ClearError("清除故障"),
    UpdateMeter("升级"),
    BindCard("卡号绑定");

    private final String value;

    InstructTypeEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static InstructTypeEnum toType(String value) {
        return Stream.of(InstructTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    @JsonValue
    public String getValue(){
        return value;
    }
}
