package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.Optional;
import java.util.stream.Stream;

/**
 * 物联网表服务  物联网对接模式类型
 * @author Mr.river
 */
public enum IOTDockingModeEnum {
    //电信物联网平台
    TELECOM("电信"),
    //移动OneNet物联网平台
    ONENET("移动"),
    //其他
    OTHER("其他");

    private String value;

    IOTDockingModeEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static IOTDockingModeEnum toType(String value) {
        return Stream.of(IOTDockingModeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(IOTDockingModeEnum.OTHER.setValue(value));
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    @JsonValue
    public String getValue(){
        return value;
    }

    private IOTDockingModeEnum setValue(String value){
        if(!Optional.ofNullable(value).isPresent()){
            value = "Null";
        }
        this.value = value;
        return this;
    }
}
