package com.aote.webmeter.common.utils;

import javax.validation.constraints.NotNull;
import java.util.Optional;
import java.util.function.Function;

/**
 * 声明参数器中多选一的参数
 *
 * 使用场景：当业务需要多个参数中的其中一个参数时，可以用NecessaryValue包装这些参数，从而实现参数校验和重赋值的功能
 * @param <K> 输入值类型
 * @param <T> 输出值类型
 * @author Mr.river
 */
public class NecessaryValue<K, T> {
    /**
     * 传入值
     */
    private final K value;
    /**
     * 参数优先级
     * 参数构造器将按照该值依次检索参数
     */
    private final Integer order;
    /**
     * 参数扩展支持
     */
    private Inner<T> inner;

    public NecessaryValue(@NotNull Integer order, @NotNull K value, Inner<T> inner){
        this.value = value;
        this.order = order;
        this.inner = inner;
    }

    public NecessaryValue(@NotNull Integer order,@NotNull K value){
        this.value = value;
        this.order = order;
    }

    public T getOutValue(){
        return Optional.ofNullable(inner)
                .map(Inner::map)
                .orElseGet(()-> (T) getInValue());
    }

    public K getInValue(){
        return value;
    }

    public Integer getOrder(){
        return order;
    }

    @Override
    public String toString(){
        return Optional.ofNullable(value).map(String::valueOf).orElse(null);
    }

    @FunctionalInterface
    public interface Inner<T> {
        /**
         * 当值不为null时，通过该方法重赋值并输出值，作用与Optional的map方法相当
         * @see java.util.Optional#map(Function)
         * @return 重赋值
         */
        T map();
    }
}
