package com.aote.webmeter.common.template.result;


import com.aote.webmeter.common.basic.manage.param.AbstractParamBuilder;
import com.aote.webmeter.common.utils.NecessaryValue;
import com.aote.webmeter.enums.business.InstructStateEnum;
import lombok.Getter;

import java.util.Optional;

/**
 * 执行指令模板的返回
 *
 * @author Mr.river
 */
@Getter
public class RunInstructTemplateResult extends TemplateResult {
    /**
     * 指令执行状态结果
     */
    private NecessaryValue<InstructStateEnum, InstructStateEnum> state;
    /**
     * 是否不进行指令更新
     */
    private NecessaryValue<Boolean, Boolean> disableUpdate;
    /**
     * 指令响应信息
     */
    private String receiveMsg;
    /**
     * 指令元数据
     */
    private String metaData;
    /**
     * 需要保存的指令唯一标识
     */
    private String syncCommandId;
    /**
     * 指令自动托管：指令执行结果不是失败时，自动下发后续指令，默认为false，
     * 注意：这是一种利用业务特性递归实现指令循环发送的写法，你需要确保业务中支持指令回调，并且主动调用了执行指令的方法。
     * 使用continue会丢失具体执行指令方法的返回值
     */
    private Boolean trusteeship;

    private RunInstructTemplateResult(){

    }

    public static class Builder extends AbstractParamBuilder {
        private final RunInstructTemplateResult result;

        public Builder() {
            result = new RunInstructTemplateResult();
        }

        @Override
        public RunInstructTemplateResult build() {
            checkAndGetNecessaryParams(this.result);
            result.trusteeship = Optional.ofNullable(result.trusteeship).orElse(false);
            result.receiveMsg = Optional.ofNullable(result.receiveMsg).orElse("未知");
            return result;
        }

        public Builder state(InstructStateEnum state){
            result.state = new NecessaryValue<>(1, state, () -> state);
            return this;
        }

        public Builder disableUpdate(boolean disableUpdate){
            result.disableUpdate = new NecessaryValue<>(3, disableUpdate, () -> disableUpdate);
            return this;
        }

        public Builder receiveMsg(String receiveMsg){
            result.receiveMsg = receiveMsg;
            return this;
        }

        public Builder metaData(String metaData){
            result.metaData = metaData;
            return this;
        }

        public Builder syncCommandId(String syncCommandId){
            result.syncCommandId = syncCommandId;
            return this;
        }

        public Builder trusteeship(boolean trusteeship){
            result.trusteeship = trusteeship;
            return this;
        }
    }

    public InstructStateEnum getState(){
        return state.getInValue();
    }

    public boolean getDisableUpdate(){
        return Optional.ofNullable(disableUpdate).map(NecessaryValue::getInValue).orElse(false);
    }
}
