package com.aote.webmeter.common.modules;

import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.exception.WebmeterException;

/**
 * 抽象物联网表
 *
 * @author Mr.river
 */
public interface AbstractRunInstruct {
    /**
     * 执行开户指令
     * @return 调用执行指令模板时注入业务
     */
    RunTemplatePour runOpenAccount();
    /**
     * 执行换表/注销指令
     * @return 调用执行指令模板时注入业务
     */
    RunTemplatePour runChangeMeter();
    /**
     * 执行充值指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runGasRecharge(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行调价指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runSetPrice(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行阀控指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runValveControl(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }

    /**
     * 执行余额同步指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runChargeMeter(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行设置参数指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runSetParams(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行读取参数指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runReadParams(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行初始化/清零指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runInitialization(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行卡号绑定指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runBindCard(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行校时指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runSetTime(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行结束下发指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runCloseConnection(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
    /**
     * 执行同步价格计划指令
     * @return 调用执行指令模板时注入业务
     */
    default RunTemplatePour runDetailPrice(){
        throw new WebmeterException(BusinessExceptionCodeEnum.NO_IMPL_METHOD_BY_INSTRUCT);
    }
}
