package com.aote.webmeter.common.entity;

import com.af.plugins.JsonTools;
import com.aote.util.JsonHelper;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SaveInstructParam;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.json.JSONObject;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 指令实体
 *
 * @author Mr.river
 */
@Data
public class InstructEntity {
    /**
     * ID
     */
    private Integer id;
    /**
     * 表档案编号
     */
    private String f_user_id;
    /**
     * 表档案ID
     */
    private Integer f_userfiles_id;
    /**
     * 户档案ID
     */
    private String f_userinfo_id;
    /**
     * 气表品牌名称
     */
    private String f_manufacturers;
    /**
     * 气表品牌别名
     */
    private String f_alias;
    /**
     * 指令对应业务记录ID
     */
    private String f_data_id;
    /**
     * 表号
     */
    private String f_meternumber;
    /**
     * 操作人
     */
    private InstructInputtorEnum f_inputtor;
    /**
     * 版本号
     */
    private Integer version;
    /**
     * 指令类型
     */
    private InstructTypeEnum f_instruct_type;
    /**
     * 指令副类型
     */
    private String f_instruct_title;
    /**
     * 指令内容
     */
    private String f_instruct_content;
    /**
     * 指令元数据
     */
    private String f_instruct_meta_data;

    /**
     * 指令生成时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date f_instruct_date;

    /**
     * 指令发送时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date f_send_date;

    /**
     * 指令响应时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date f_callback_date;

    /**
     * 指令状态
     */
    private InstructStateEnum f_instruct_state;
    /**
     * 指令响应信息
     */
    private String f_receive_state;
    /**
     * 指令对应的抄表记录ID
     */
    private String f_meteread_id;
    /**
     * 指令备注
     */
    private String f_info;
    /**
     * 指令标识
     */
    private String f_commandId;
    /**
     * 分公司信息
     */
    private String f_filiale;
    private String f_filialeid;
    private String f_filialeids;
    private String f_outlets;
    private String f_orgstr;
    private String f_orgid;
    private String f_depid;
    private String f_orgname;
    private String f_depname;

    private InstructEntity(){

    }

    public static class Builder {
        private final InstructEntity entity;

        public Builder(SaveInstructParam param, JSONObject userFiles) {
            JSONObject instruct = JsonHelper.toJSON(param);
            JsonTools.addJSON(instruct, userFiles);
            entity = JsonHelper.toParse(instruct, InstructEntity.class);
        }

        public InstructEntity build() {
            return entity;
        }
    }
}
