package com.aote.webmeter.common.dto;

import com.aote.util.JsonHelper;
import com.aote.webmeter.enums.business.IOTDockingModeEnum;
import com.aote.webmeter.enums.business.SaleTypeEnum;
import com.aote.webmeter.enums.business.SettlementTypeEnum;
import com.aote.webmeter.enums.business.TelecomDockingModeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.json.JSONObject;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 查询待开户的档案数据-Result
 * 包含以下SQL
 * getOpenAccount@sql
 *
 * @author Mr.river
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GetOpenAccountDataDto extends GetInstructMetaDataDto {
    /**
     * 表档案ID
     */
    private String userId;
    /**
     * 表档案编号
     */
    private String f_user_id;
    /**
     * 表号
     */
    private String f_meternumber;
    /**
     * 用户姓名
     */
    private String f_user_name;
    /**
     * 结算方式
     */
    private SettlementTypeEnum f_collection_type;
    /**
     * 电话
     */
    private String f_user_phone;
    /**
     * 地址
     */
    private String f_address;
    /**
     * 卡号
     */
    private String f_card_id;
    /**
     * 气表型号
     */
    private String f_meter_style;
    /**
     * 阶梯周期
     */
    private Integer f_stairmonths;
    /**
     * 阶梯开始时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date start_date;
    /**
     * 气价ID
     */
    private Integer stairid;
    /**
     * IMEI号
     */
    private String f_imei;
    /**
     * 物联网对接模式类型
     */
    private IOTDockingModeEnum f_iot_type;
    /**
     * 电信物联网对接模式类型
     */
    private TelecomDockingModeEnum f_terminal_id;

    /**
     * 收费记录ID
     */
    private String sellid;
    /**
     * 收费类型
     */
    private SaleTypeEnum type;

    private GetOpenAccountDataDto(){

    }

    public static class Builder {
        private final GetOpenAccountDataDto dto;

        public Builder(JSONObject getOpenAccountData) {
            dto = JsonHelper.toParse(getOpenAccountData, GetOpenAccountDataDto.class);
        }

        public GetOpenAccountDataDto build() {
            return dto;
        }
    }
}
