/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.runInstruct;

import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SetInstructStateParam;
import com.aote.webmeter.common.dto.GetInstructDto;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplate;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.common.template.pour.RunTemplatePourCall;
import com.aote.webmeter.common.template.pour.param.RunTemplatePourCallParam;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.MeterTableStateEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.Optional;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Template
public class BasicRunInstructTemplate
extends AbstractTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicRunInstructTemplate.class);
    private InstructTypeEnum type;
    private GetInstructDto getInstructDto;
    private RunTemplatePour runTemplatePour;
    private JSONObject templatePourExtraParams;
    private String moduleName;
    private RunTemplatePourCall runTemplatePourCall;
    private JSONObject templatePourCallExtraParams;
    private final InstructManage instructManage;

    private BasicRunInstructTemplate(InstructManage instructManage) {
        this.instructManage = instructManage;
    }

    @Override
    protected void beforeExec() {
    }

    @Override
    public RunInstructTemplateResult exec() {
        RunInstructTemplateResult result;
        if (Optional.ofNullable(this.moduleName).isPresent()) {
            WebMeterInfo.setModuleName(this.moduleName);
        }
        String instructTypeValue = this.getInstructDto.getF_instruct_type().getValue();
        if (Optional.ofNullable(this.getInstructDto.getF_table_state()).isPresent() && this.getInstructDto.getF_table_state() != MeterTableStateEnum.NORMAL && this.type != InstructTypeEnum.ChangeMeter) {
            String receiveMsg = "\u5df2\u81ea\u52a8\u53d6\u6d88\uff0c\u539f\u56e0\uff1a\u8868\u6863\u6848\u72b6\u6001\u4e3a" + (Object)((Object)this.getInstructDto.getF_table_state()) + "\uff0c\u9884\u671f\u503c\uff1a" + MeterTableStateEnum.NORMAL.getValue();
            SetInstructStateParam param = new SetInstructStateParam.Builder(InstructStateEnum.CANCELED).id(this.getInstructDto.getId()).receiveMsg(receiveMsg).build();
            this.instructManage.setInstructState(param);
            result = new RunInstructTemplateResult.Builder().state(InstructStateEnum.FAILED).receiveMsg(receiveMsg).build();
        } else {
            String meterNumber = this.getInstructDto.getF_meternumber();
            if (Optional.ofNullable(meterNumber).isPresent()) {
                LOGGER.info("----------" + meterNumber + "\u5f00\u59cb\u6267\u884c" + instructTypeValue + "\u6307\u4ee4");
            } else {
                LOGGER.info("----------\u5f00\u59cb\u6267\u884c" + instructTypeValue + "\u6307\u4ee4");
            }
            result = this.runTemplatePour.run(this.getInstructDto, this.templatePourExtraParams);
            if (Optional.ofNullable(this.runTemplatePourCall).isPresent()) {
                RunTemplatePourCallParam param = new RunTemplatePourCallParam.Builder(this.getInstructDto.getUserId(), this.getInstructDto.getF_meternumber(), result.getState(), this.getInstructDto).extraParams(this.templatePourCallExtraParams).build();
                this.runTemplatePourCall.run(param);
            }
            if (!result.getDisableUpdate()) {
                String metaData = Optional.ofNullable(result.getMetaData()).orElseGet(() -> this.getInstructDto.getF_instruct_content());
                SetInstructStateParam param = new SetInstructStateParam.Builder(result.getState()).receiveMsg(result.getReceiveMsg()).metaData(metaData).syncCommandId(result.getSyncCommandId()).id(this.getInstructDto.getId()).build();
                this.instructManage.setInstructState(param);
            } else {
                LOGGER.info("\u7981\u7528\u66f4\u65b0\u6307\u4ee4\u72b6\u6001");
            }
        }
        LOGGER.info("ID\uff1a{}\uff0c\u6307\u4ee4\u7c7b\u578b\uff1a{}\uff0c\u6267\u884c\u5b8c\u6bd5\uff1a\u72b6\u6001\uff1a{}\uff0c\u54cd\u5e94\u4fe1\u606f\uff1a{}", new Object[]{this.getInstructDto.getId(), instructTypeValue, result.getState().getValue(), result.getReceiveMsg()});
        return result;
    }

    @Override
    protected void afterExec() {
    }

    public static class Builder
    extends AbstractTemplateBuilder {
        private final BasicRunInstructTemplate template = SpringBeanUtil.getBean(BasicRunInstructTemplate.class);

        public Builder(InstructTypeEnum type, GetInstructDto getInstructDto, RunTemplatePour pour) {
            this.template.type = type;
            this.template.getInstructDto = getInstructDto;
            this.template.runTemplatePour = pour;
        }

        @Override
        public BasicRunInstructTemplate build() {
            return this.template;
        }

        public Builder moduleName(String moduleName) {
            this.template.moduleName = moduleName;
            return this;
        }

        public Builder templatePourExtraParams(JSONObject templatePourExtraParams) {
            this.template.templatePourExtraParams = templatePourExtraParams;
            return this;
        }

        public Builder templatePourCall(RunTemplatePourCall pourCall) {
            this.template.runTemplatePourCall = pourCall;
            return this;
        }

        public Builder templatePourCallExtraParams(JSONObject pourCallParam) {
            this.template.templatePourCallExtraParams = pourCallParam;
            return this;
        }
    }
}

