/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.server.udp;

import com.af.plugins.JsonTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.enums.MsgTypeEnum;
import com.aote.webmeter.server.tcp.TcpListener;
import com.aote.webmeter.server.udp.UdpServer;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class UdpListener
implements ServletContextListener {
    private List<UdpServer> udpServers;
    private static final String PATH = "config/server/UDPListenerConfig.json";

    public void contextInitialized(ServletContextEvent sce) {
        if (TcpListener.class.getClassLoader().getResourceAsStream(PATH) != null) {
            JSONArray array = JsonTools.readJsonArrayFile((String)PATH);
            this.udpServers = new ArrayList<UdpServer>();
            array.forEach(item -> {
                JSONObject params = (JSONObject)item;
                String name = params.getString("name");
                String logicName = params.getString("callBackName");
                JSONArray ports = params.getJSONArray("udpPort");
                LogicServer service = (LogicServer)WebApplicationContextUtils.getWebApplicationContext((ServletContext)sce.getServletContext()).getBean(LogicServer.class);
                String msgReceiveType = params.getString("msgReceiveType");
                String msgSendType = params.getString("msgSendType");
                for (int i = 0; i < ports.length(); ++i) {
                    UdpServer udpServer = new UdpServer(name, logicName, ports.getInt(i), service, MsgTypeEnum.toType(msgReceiveType), MsgTypeEnum.toType(msgSendType));
                    this.udpServers.add(udpServer);
                }
            });
        }
        for (UdpServer udpServer : this.udpServers) {
            udpServer.start();
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        for (UdpServer udpServer : this.udpServers) {
            if (udpServer == null || !udpServer.isInterrupted()) continue;
            udpServer.interrupt();
        }
    }
}

