/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.saveInstruct;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.dto.GetOpenAccountDataDto;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.pour.SaveTemplatePour;
import com.aote.webmeter.common.template.saveInstruct.BasicSaveInstructTemplate;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.OpenAccountStateEnum;
import com.aote.webmeter.enums.business.SaleTypeEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.SpringBeanUtil;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Template
public class SaveOpenAccountInstructTemplate
extends BasicSaveInstructTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveOpenAccountInstructTemplate.class);
    private GetOpenAccountDataDto dto;
    private SaveTemplatePour saveTemplatePour;
    private Boolean isSellUpdate;

    protected SaveOpenAccountInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao) {
        super(instructManage, userFilesDao, saleDataDao, changeMeterDataDao);
    }

    @Override
    protected void beforeExec() {
        this.userId = this.dto.getUserId();
        this.type = InstructTypeEnum.OpenAccount;
        this.content = JsonHelper.toJSON((Object)this.saveTemplatePour.run(this.dto));
        this.inputtor = InstructInputtorEnum.SYSTEM_FILES_LIFE_CYCLE;
        if (this.isSellUpdate.booleanValue()) {
            this.title = "\u5f00\u6237\u5145\u503c";
            this.dataId = this.dto.getSellid();
        } else {
            this.title = "\u5f00\u6237\u5efa\u6863";
            this.dataId = this.dto.getUserId();
        }
    }

    @Override
    protected void afterExec() {
        this.userFilesDao.updateMeterOpenAccountState(this.dto.getUserId(), OpenAccountStateEnum.READY_ACCOUNT);
        if (this.isSellUpdate.booleanValue()) {
            SaleTypeEnum typeEnum = this.dto.getType();
            if (typeEnum == SaleTypeEnum.CHARGE) {
                this.saleDataDao.updateSellingGasSyncState(this.dto.getSellid());
            } else if (typeEnum == SaleTypeEnum.REPLACE_METER_ADD_VOLUME || typeEnum == SaleTypeEnum.ADD_FEE) {
                this.saleDataDao.updateSupplyGasSyncState(this.dto.getSellid());
            } else {
                throw new WebmeterException(BusinessExceptionCodeEnum.INVALID_RECHARGE_SOURCE_TYPE);
            }
        }
    }

    public static class Builder
    extends AbstractTemplateBuilder {
        private final SaveOpenAccountInstructTemplate template = SpringBeanUtil.getBean(SaveOpenAccountInstructTemplate.class);

        public Builder(GetOpenAccountDataDto dto, SaveTemplatePour saveTemplatePour) {
            this.template.dto = dto;
            this.template.saveTemplatePour = saveTemplatePour;
        }

        @Override
        public SaveOpenAccountInstructTemplate build() {
            this.template.isSellUpdate = Optional.ofNullable(this.template.isSellUpdate).orElse(false);
            return this.template;
        }

        public Builder moduleName(String moduleName) {
            this.template.moduleName = moduleName;
            return this;
        }

        public Builder isSellUpdate(Boolean isSellUpdate) {
            this.template.isSellUpdate = isSellUpdate;
            return this;
        }
    }
}

