-- 公共SQL：生成同步气价计划指令（适用V1）
-- 必选参数
-- stairPriceSync：气价方案同步状态字段

SELECT
    -- 价格方案ID
    id                                         stairId,
    -- 价格方案名称
    f_price_name                               price_name,
    -- 阶梯周期（月）
    ISNULL(f_stairmonths, 1)                   f_stairmonths,
    -- 阶梯开始时间
    ISNULL(f_stair_start_date, f_perform_date) start_date,
    -- 价格生效时间
    f_perform_date,
    -- 是否采暖气价
    0 f_isheat
FROM t_stairprice s
WHERE s.f_state = '有效'
  AND getdate() >= s.f_perform_date
  AND getdate() <= s.f_end_date
  AND (s.${stairPriceSync} IS NULL or s.${stairPriceSync} = '未同步')
