/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.stream.Stream;

public enum InstructStateEnum {
    READY("\u5f85\u53d1\u9001", -1, "\u672a\u77e5"),
    SUCCESSFUL("\u6267\u884c\u6210\u529f", 0, "\u6210\u529f"),
    FAILED("\u6267\u884c\u5931\u8d25", 1, "\u5931\u8d25"),
    ALREADY_SENT("\u5df2\u53d1\u9001", 2, "\u7b49\u5f85\u8868\u7aef\u6267\u884c"),
    TIME_OUT("\u54cd\u5e94\u8d85\u65f6", 3, "\u8868\u7aef\u54cd\u5e94\u8d85\u65f6"),
    CANCELED("\u5ffd\u7565\u5197\u4f59", 4, "\u81ea\u52a8\u53d6\u6d88"),
    DELAYED("\u5df2\u5ef6\u8fdf", 5, "\u5ef6\u8fdf\u53d1\u9001"),
    NO_RESPONSE("\u65e0\u54cd\u5e94", 6, "\u672a\u6536\u5230\u8868\u7aef\u54cd\u5e94");

    private final String value;
    private final Integer code;
    private final String defaultReceiveMsg;

    private InstructStateEnum(String value, Integer code, String defaultReceiveMsg) {
        this.value = value;
        this.code = code;
        this.defaultReceiveMsg = defaultReceiveMsg;
    }

    @JsonCreator
    public static InstructStateEnum toType(String value) {
        return Stream.of(InstructStateEnum.values()).filter(p -> p.value.equals(value)).findAny().orElse(null);
    }

    public static InstructStateEnum toType(Integer code) {
        return Stream.of(InstructStateEnum.values()).filter(p -> p.code.equals(code)).findAny().orElse(null);
    }

    public static boolean is(String value) {
        return InstructStateEnum.toType(value) != null;
    }

    public static boolean is(Integer code) {
        return InstructStateEnum.toType(code) != null;
    }

    @JsonValue
    public String getValue() {
        return this.value;
    }

    public int getCode() {
        return this.code;
    }

    public String getReceiveMsg() {
        return this.defaultReceiveMsg;
    }
}

