/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage.param.instructmanage;

import com.aote.webmeter.common.basic.manage.param.AbstractParam;
import com.aote.webmeter.common.basic.manage.param.AbstractParamBuilder;
import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.common.utils.NecessaryValue;
import com.aote.webmeter.tools.StandardCompatTools;
import java.util.Optional;
import org.json.JSONObject;

public class RunInstructParam
extends AbstractParam {
    private NecessaryValue<String, Condition> userId;
    private NecessaryValue<Condition, Condition> condition;
    private Boolean trusteeship;
    private JSONObject extraParams;

    private RunInstructParam() {
    }

    public void setTrusteeship(Boolean trusteeship) {
        this.trusteeship = trusteeship;
    }

    public Condition getCondition() {
        return this.condition.getOutValue();
    }

    public String getUserId() {
        return this.userId.getInValue();
    }

    public Boolean getTrusteeship() {
        return this.trusteeship;
    }

    public JSONObject getExtraParams() {
        return this.extraParams;
    }

    public static class Builder
    extends AbstractParamBuilder {
        private final RunInstructParam param = new RunInstructParam();

        @Override
        public RunInstructParam build() {
            this.param.condition = this.checkAndGetNecessaryParams(this.param);
            this.param.trusteeship = Optional.ofNullable(this.param.trusteeship).orElse(false);
            this.param.extraParams = Optional.ofNullable(this.param.extraParams).orElseGet(JSONObject::new);
            return this.param;
        }

        public Builder userId(String userId) {
            this.param.userId = new NecessaryValue<String, Condition>(1, userId, () -> StandardCompatTools.getBasicCondition(userId));
            return this;
        }

        public Builder condition(Condition condition) {
            this.param.condition = new NecessaryValue(2, condition);
            return this;
        }

        public Builder trusteeship(boolean trusteeship) {
            this.param.trusteeship = trusteeship;
            return this;
        }

        public Builder extraParams(JSONObject extraParams) {
            this.param.extraParams = extraParams;
            return this;
        }
    }
}

