/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.basic.manage;

import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.webmeter.common.basic.manage.param.instructmanage.GetWaitInstructParam;
import com.aote.webmeter.common.basic.manage.param.instructmanage.RunInstructParam;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SaveInstructParam;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SetInstructStateParam;
import com.aote.webmeter.common.basic.manage.result.GetWaitInstructResult;
import com.aote.webmeter.common.dao.InstructDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.dto.GetInstructDto;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.common.template.runInstruct.BasicRunInstructTemplate;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.GetInstructsTools;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class InstructManage {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstructManage.class);
    private final EntityServer entityServer;
    private final InstructDao instructDao;
    private final UserFilesDao userFilesDao;

    public InstructManage(EntityServer entityServer, InstructDao instructDao, UserFilesDao userFilesDao, LogicServer logicServer) {
        this.entityServer = entityServer;
        this.instructDao = instructDao;
        this.userFilesDao = userFilesDao;
    }

    public String save(SaveInstructParam param) {
        JSONArray userFilesInfo = this.userFilesDao.getMeterInfoByCreateInstruct(param.getUserId(), param.getF_alias(), null);
        if (param.getF_inputtor() != InstructInputtorEnum.SYSTEM_DEFAULT && param.getF_inputtor() != InstructInputtorEnum.CHARGE) {
            if (param.getF_instruct_type() == InstructTypeEnum.ValveControl) {
                this.instructDao.updateRedundancyValveControlInstruct(param.getUserId());
            } else {
                this.instructDao.updateRedundancyOtherInstruct(param.getUserId(), param.getF_instruct_type(), param.getF_instruct_title());
            }
        }
        JSONObject userFiles = userFilesInfo.getJSONObject(0);
        InstructEntity instructData = new InstructEntity.Builder(param, userFiles).build();
        String tableName = CompatTools.getInstructTableName();
        JSONObject instruct = JsonTools.convertToJson((String)this.entityServer.partialSaveByEntity(tableName, (Object)instructData));
        LOGGER.info("--------{}\u6307\u4ee4\u4fdd\u5b58\u6210\u529f--------", (Object)param.getF_instruct_type().getValue());
        return String.valueOf(instruct.get("id"));
    }

    public int setInstructState(SetInstructStateParam param) {
        return this.instructDao.updateInstructState(param);
    }

    public RunInstructTemplateResult runTemplateInstruct(RunInstructParam param) {
        RunInstructTemplateResult result = null;
        GetWaitInstructResult waitInstruct = this.getWaitInstructResult(new GetWaitInstructParam.Builder().build(param));
        if (waitInstruct.getTotal() > 0) {
            GetInstructDto dto = waitInstruct.getInstructs().get(0);
            InstructTypeEnum typeEnum = dto.getF_instruct_type();
            LOGGER.info("\u5f85\u6267\u884c\u6307\u4ee4\u7c7b\u578b\uff1a" + typeEnum.getValue());
            JSONObject extraParams = new JSONObject();
            extraParams.put("instructCount", (Object)waitInstruct.getTotal());
            extraParams.put("deviceId", (Object)dto.getF_device_id());
            JsonTools.addJSON((JSONObject)extraParams, (JSONObject)param.getExtraParams());
            RunTemplatePour pour = GetInstructsTools.getInstructPour(typeEnum.getValue());
            BasicRunInstructTemplate.Builder templateBuilder = GetInstructsTools.getInstructTemplateObject(typeEnum, dto, pour);
            BasicRunInstructTemplate template = templateBuilder.templatePourExtraParams(extraParams).build();
            result = template.exec();
            if (param.getTrusteeship().booleanValue() && result.getState() != InstructStateEnum.FAILED) {
                LOGGER.info("\u7ee7\u7eed\u6267\u884c\u540e\u7eed\u6307\u4ee4");
                param.setTrusteeship(result.getTrusteeship());
                this.runTemplateInstruct(param);
            }
        } else {
            LOGGER.info("\u6240\u6709\u5f85\u53d1\u9001\u6307\u4ee4\u6267\u884c\u5b8c\u6bd5\uff01");
        }
        return result;
    }

    public GetWaitInstructResult getWaitInstructResult(GetWaitInstructParam param) {
        return this.instructDao.getWaitInstructs(param.getCondition());
    }

    public void updateInstructStatus(String userId) {
        this.instructDao.updateNoResponseAndTimeOutLastingInstruct(userId);
        this.instructDao.updateNoResponseTemporaryInstruct(userId);
        this.instructDao.updateReadyTemporaryInstruct(userId);
    }
}

