package com.aote.webmeter.tools.iot.aep;

import java.util.stream.Stream;

/**
 * IOT模块配置项枚举
 *
 * @author Mr.river
 */
public enum IotModuleConfigEnum {

    //原生AEP平台 产品ID
    AEP_PRODUCT_ID("aepProductId"),
    //原生AEP平台 MasterKey
    AEP_MASTER_KEY("aepMasterKey"),
    //原生AEP平台 AppKey
    AEP_APP_KEY("aepAppKey"),
    //原生AEP平台 App密钥
    AEP_APP_SECRET("aepAppSecret");

    private final String value;

    IotModuleConfigEnum(String value) {
        this.value = value;
    }

    public static IotModuleConfigEnum toType(String value) {
        return Stream.of(IotModuleConfigEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
