/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.onenet;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class getMQTTToken {
    public static String assembleToken(String accessKey) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        StringBuilder sb = new StringBuilder();
        String version = "2018-10-31";
        String resourceName = "products/123123";
        String expirationTime = System.currentTimeMillis() / 1000L + 8640000L + "";
        String signatureMethod = SignatureMethod.SHA1.name().toLowerCase();
        String res = URLEncoder.encode(resourceName, "UTF-8");
        String sig = URLEncoder.encode(getMQTTToken.generatorSignature(version, resourceName, expirationTime, accessKey, signatureMethod), "UTF-8");
        sb.append("version=").append(version).append("&res=").append(res).append("&et=").append(expirationTime).append("&method=").append(signatureMethod).append("&sign=").append(sig);
        return sb.toString();
    }

    public static String generatorSignature(String version, String resourceName, String expirationTime, String accessKey, String signatureMethod) throws NoSuchAlgorithmException, InvalidKeyException {
        String encryptText = expirationTime + "\n" + signatureMethod + "\n" + resourceName + "\n" + version;
        byte[] bytes = getMQTTToken.HmacEncrypt(encryptText, accessKey, signatureMethod);
        String signature = Base64.getEncoder().encodeToString(bytes);
        return signature;
    }

    public static byte[] HmacEncrypt(String data, String key, String signatureMethod) throws NoSuchAlgorithmException, InvalidKeyException {
        SecretKeySpec signinKey = null;
        signinKey = new SecretKeySpec(Base64.getDecoder().decode(key), "Hmac" + signatureMethod.toUpperCase());
        Mac mac = null;
        mac = Mac.getInstance("Hmac" + signatureMethod.toUpperCase());
        mac.init(signinKey);
        return mac.doFinal(data.getBytes());
    }

    public static void main(String[] args) throws UnsupportedEncodingException, NoSuchAlgorithmException, InvalidKeyException {
        System.out.println(getMQTTToken.assembleToken("3dv6SLQ4oluixPlcs5xZCH31CcE="));
    }

    public static enum SignatureMethod {
        SHA1,
        MD5,
        SHA256;

    }
}

