/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.tools.iot.aep;

import com.af.expression.exception.ServiceException;
import com.af.plugins.JsonTools;
import com.aote.webmeter.tools.WebMeterInfo;
import com.aote.webmeter.tools.iot.aep.AEPProtocolTypeEnum;
import com.aote.webmeter.tools.iot.aep.IotModuleConfigEnum;
import com.ctg.ag.sdk.biz.AepDeviceCommandClient;
import com.ctg.ag.sdk.biz.AepDeviceCommandLwmProfileClient;
import com.ctg.ag.sdk.biz.AepDeviceManagementClient;
import com.ctg.ag.sdk.biz.aep_device_command.CreateCommandRequest;
import com.ctg.ag.sdk.biz.aep_device_command_lwm_profile.CreateCommandLwm2mProfileRequest;
import com.ctg.ag.sdk.biz.aep_device_management.CreateDeviceRequest;
import com.ctg.ag.sdk.biz.aep_device_management.DeleteDeviceRequest;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class AEPApiService {
    private static final Map<String, AEPClientMapItem> AEP_CLIENT_MAP_ITEM_MAP = new ConcurrentHashMap<String, AEPClientMapItem>();
    private static final Logger LOGGER = LoggerFactory.getLogger(AEPApiService.class);

    private AEPClientMapItem getClientMap(String appKey) {
        if (!AEP_CLIENT_MAP_ITEM_MAP.containsKey(appKey)) {
            String appSecret = WebMeterInfo.getString(IotModuleConfigEnum.AEP_APP_SECRET.getValue());
            AEP_CLIENT_MAP_ITEM_MAP.put(appKey, new AEPClientMapItem(appKey, appSecret));
        }
        return AEP_CLIENT_MAP_ITEM_MAP.get(appKey);
    }

    public JSONObject sendCommand(String deviceId, Object value, AEPProtocolTypeEnum aepProtocolTypeEnum, String serviceId, String method) {
        JSONObject content;
        block12: {
            block11: {
                content = new JSONObject();
                if (serviceId != null && method != null) {
                    return this.sendCommandByProfile(serviceId, method, deviceId, value);
                }
                if (serviceId == null) break block11;
                switch (aepProtocolTypeEnum) {
                    case MQTT: 
                    case LWM2M: 
                    case TR069: {
                        if (!(value instanceof JSONObject)) {
                            throw new ServiceException("\u975e\u900f\u4f20\u6a21\u5f0f\u4ec5\u652f\u6301JSON\u683c\u5f0f\u6570\u636e");
                        }
                        content.put("params", value);
                        content.put("serviceIdentifier", (Object)serviceId);
                        break block12;
                    }
                    default: {
                        throw new ServiceException("\u8be5\u534f\u8bae\u4e0d\u652f\u6301\u975e\u900f\u4f20\u6a21\u5f0f\uff1a" + (Object)((Object)aepProtocolTypeEnum));
                    }
                }
            }
            switch (aepProtocolTypeEnum) {
                case MQTT: 
                case TR069: {
                    if (value instanceof JSONObject) {
                        content.put("payload", value);
                        break;
                    }
                    throw new ServiceException("MQTT,TR069\u534f\u8bae\u7684\u900f\u4f20\u6a21\u5f0f\u4ec5\u652f\u6301JSON\u683c\u5f0f\u6570\u636e");
                }
                case LWM2M: 
                case TCP: {
                    if (!(value instanceof String)) {
                        throw new ServiceException("LWM2M,TCP\u534f\u8bae\u7684\u900f\u4f20\u6a21\u5f0f\u4ec5\u652f\u6301String\u683c\u5f0f\u6570\u636e");
                    }
                    content.put("payload", value);
                    content.put("dataType", 2);
                    break;
                }
                default: {
                    throw new ServiceException("\u8be5\u534f\u8bae\u4e0d\u652f\u6301\u900f\u4f20\u6a21\u5f0f\uff1a" + (Object)((Object)aepProtocolTypeEnum));
                }
            }
        }
        JSONObject requestContent = new JSONObject();
        requestContent.put("content", (Object)content);
        return this.sendCommandAction(deviceId, requestContent, (requestParams, aepClientMapItem) -> {
            byte[] resultByte;
            CreateCommandRequest request = new CreateCommandRequest();
            request.addParamMasterKey((Object)WebMeterInfo.getString(IotModuleConfigEnum.AEP_MASTER_KEY.getValue()));
            request.setBody(requestParams.toString().getBytes(StandardCharsets.UTF_8));
            try {
                resultByte = aepClientMapItem.getAepDeviceCommandClient().CreateCommand(request).getBody();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return resultByte;
        });
    }

    public JSONObject sendCommand(String deviceId, Object value, String serviceId, String method) {
        return this.sendCommand(deviceId, value, AEPProtocolTypeEnum.LWM2M, serviceId, method);
    }

    public JSONObject sendCommand(String deviceId, Object value, String serviceId) {
        return this.sendCommand(deviceId, value, AEPProtocolTypeEnum.LWM2M, serviceId, null);
    }

    public JSONObject sendCommand(String deviceId, Object value) {
        return this.sendCommand(deviceId, value, AEPProtocolTypeEnum.LWM2M, null, null);
    }

    public JSONObject sendCommandByProfile(String serviceId, String method, String deviceId, Object value) {
        JSONObject requestContent = new JSONObject();
        requestContent.put("command", (Object)new JSONObject().put("serviceId", (Object)serviceId).put("method", (Object)method).put("paras", value));
        return this.sendCommandAction(deviceId, requestContent, (requestParams, aepClientMapItem) -> {
            byte[] resultByte;
            CreateCommandLwm2mProfileRequest request = new CreateCommandLwm2mProfileRequest();
            request.addParamMasterKey((Object)WebMeterInfo.getString(IotModuleConfigEnum.AEP_MASTER_KEY.getValue()));
            request.setBody(requestParams.toString().getBytes(StandardCharsets.UTF_8));
            try {
                resultByte = aepClientMapItem.getAepDeviceCommandLwmProfileClient().CreateCommandLwm2mProfile(request).getBody();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return resultByte;
        });
    }

    private JSONObject sendCommandAction(String deviceId, JSONObject content, BiFunction<JSONObject, AEPClientMapItem, byte[]> function) {
        JSONObject requestParams = new JSONObject();
        requestParams.put("deviceId", (Object)deviceId);
        requestParams.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
        requestParams.put("productId", (Object)WebMeterInfo.getString(IotModuleConfigEnum.AEP_PRODUCT_ID.getValue()));
        requestParams.put("ttl", 0);
        JsonTools.addJSON((JSONObject)requestParams, (JSONObject)content);
        AEPClientMapItem aepClientMapItem = this.getClientMap(WebMeterInfo.getString(IotModuleConfigEnum.AEP_APP_KEY.getValue()));
        byte[] resultByte = function.apply(requestParams, aepClientMapItem);
        JSONObject response = JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
        LOGGER.info("AEP\u5e73\u53f0\u4e0b\u53d1\u6307\u4ee4\u8bf7\u6c42\uff0cbody: {}\uff0cresponse: {}", (Object)requestParams, (Object)response);
        if (response.getInt("code") == 0) {
            return new JSONObject().put("code", 0).put("commandId", (Object)response.getJSONObject("result").getString("commandId"));
        }
        return response;
    }

    public JSONObject addDevice(String imei, String meterNumber) throws Exception {
        JSONObject params = new JSONObject();
        params.put("deviceName", (Object)meterNumber);
        String deviceSn = imei;
        String deviceSnPrefix = WebMeterInfo.getString("deviceSnPrefix");
        if (deviceSnPrefix != null && !deviceSnPrefix.isEmpty()) {
            deviceSn = deviceSnPrefix + deviceSn;
        }
        params.put("deviceSn", (Object)deviceSn);
        params.put("imei", (Object)imei);
        params.put("productId", (Object)WebMeterInfo.getString(IotModuleConfigEnum.AEP_PRODUCT_ID.getValue()));
        params.put("operator", (Object)"\u4e1a\u52a1\u7cfb\u7edf");
        JSONObject other = new JSONObject();
        other.put("autoObserver", 0);
        params.put("other", (Object)other);
        CreateDeviceRequest request = new CreateDeviceRequest();
        request.setParamMasterKey((Object)WebMeterInfo.getString(IotModuleConfigEnum.AEP_MASTER_KEY.getValue()));
        request.setBody(params.toString().getBytes(StandardCharsets.UTF_8));
        AEPClientMapItem aepClientMapItem = this.getClientMap(WebMeterInfo.getString(IotModuleConfigEnum.AEP_APP_KEY.getValue()));
        byte[] resultByte = aepClientMapItem.getAepDeviceManagementClient().CreateDevice(request).getBody();
        JSONObject response = JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
        LOGGER.info("AEP\u5e73\u53f0\u521b\u5efa\u8bbe\u5907\u8bf7\u6c42\uff0cbody: {}\uff0cresponse: {}", (Object)params, (Object)response);
        int code = response.getInt("code");
        if (code == 0) {
            return new JSONObject().put("code", 0).put("msg", (Object)response.getJSONObject("result").getString("deviceId"));
        }
        return response;
    }

    public JSONObject deleteDevice(String deviceId) throws Exception {
        DeleteDeviceRequest request = new DeleteDeviceRequest();
        request.setParamMasterKey((Object)WebMeterInfo.getString(IotModuleConfigEnum.AEP_MASTER_KEY.getValue()));
        request.setParamProductId((Object)WebMeterInfo.getString(IotModuleConfigEnum.AEP_PRODUCT_ID.getValue()));
        request.setParamDeviceIds((Object)deviceId);
        AEPClientMapItem aepClientMapItem = this.getClientMap(WebMeterInfo.getString(IotModuleConfigEnum.AEP_APP_KEY.getValue()));
        byte[] resultByte = aepClientMapItem.getAepDeviceManagementClient().DeleteDevice(request).getBody();
        JSONObject response = JsonTools.convertToJson((String)new String(resultByte, StandardCharsets.UTF_8));
        LOGGER.info("AEP\u5e73\u53f0\u5220\u9664\u8bbe\u5907\u8bf7\u6c42\uff0cdeviceId: {}, response: {}", (Object)deviceId, (Object)response);
        return response;
    }

    private static class AEPClientMapItem {
        private final AepDeviceCommandClient aepDeviceCommandClient;
        private final AepDeviceCommandLwmProfileClient aepDeviceCommandLwmProfileClient;
        private final AepDeviceManagementClient aepDeviceManagementClient;

        public AEPClientMapItem(String appKey, String appSecret) {
            this.aepDeviceCommandClient = (AepDeviceCommandClient)AepDeviceCommandClient.newClient().appKey(appKey).appSecret(appSecret).build();
            this.aepDeviceCommandLwmProfileClient = (AepDeviceCommandLwmProfileClient)AepDeviceCommandLwmProfileClient.newClient().appKey(appKey).appSecret(appSecret).build();
            this.aepDeviceManagementClient = (AepDeviceManagementClient)AepDeviceManagementClient.newClient().appKey(appKey).appSecret(appSecret).build();
        }

        public AepDeviceCommandClient getAepDeviceCommandClient() {
            return this.aepDeviceCommandClient;
        }

        public AepDeviceCommandLwmProfileClient getAepDeviceCommandLwmProfileClient() {
            return this.aepDeviceCommandLwmProfileClient;
        }

        public AepDeviceManagementClient getAepDeviceManagementClient() {
            return this.aepDeviceManagementClient;
        }
    }
}

