/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.socket.core.channel.impl;

import com.af.plugins.ConvertTools;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.channel.AbstractChannelHandler;
import com.aote.webmeter.socket.core.client.ClientManager;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatagramPacketChannelHandler
extends AbstractChannelHandler<DatagramPacket> {
    private final Logger LOGGER = LoggerFactory.getLogger(DatagramPacketChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket message) {
        byte[] respBytes;
        SocketConfigItem configItem = ClientManager.getConfig();
        String response = this.runBusiness((ByteBuf)message.content(), ctx.channel().remoteAddress().toString());
        switch (configItem.getEncodeType()) {
            case BASE64: {
                respBytes = ConvertTools.base64Decode((byte[])response.getBytes());
                break;
            }
            case HEX: {
                try {
                    respBytes = ConvertTools.hexStrToByte((String)response);
                    break;
                }
                catch (DecoderException e) {
                    throw new RuntimeException(e);
                }
            }
            case HEX_BASE64: {
                try {
                    respBytes = ConvertTools.base64Decode((byte[])ConvertTools.hexStrToByte((String)response));
                    break;
                }
                catch (DecoderException e) {
                    throw new RuntimeException(e);
                }
            }
            default: {
                respBytes = response.getBytes(StandardCharsets.UTF_8);
            }
        }
        DatagramPacket packet = new DatagramPacket(new UnpooledByteBufAllocator(true).buffer().writeBytes(respBytes), (InetSocketAddress)message.sender());
        ctx.writeAndFlush((Object)packet);
    }
}

