/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.socket.core.channel.impl;

import com.aote.webmeter.socket.SocketServerManager;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.channel.AbstractChannelHandler;
import com.aote.webmeter.socket.core.channel.ChannelData;
import com.aote.webmeter.socket.core.client.ClientManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetSocketAddress;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufChannelHandler
extends AbstractChannelHandler<ByteBuf> {
    private final Logger LOGGER = LoggerFactory.getLogger(ByteBufChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf message) {
        try {
            Channel channel = ctx.channel();
            String port = String.valueOf(((InetSocketAddress)channel.localAddress()).getPort());
            SocketConfigItem configItem = SocketServerManager.getSocketConfigItemByPort(port);
            ClientManager.add(new ChannelData(configItem, channel));
            String address = channel.remoteAddress().toString();
            this.LOGGER.debug("channelId:{}, address:{}, \u6536\u5230\u6d88\u606f", (Object)channel.id().asLongText(), (Object)address);
            String response = this.runBusiness(message, address);
            if (response == null || response.equals("ok") || response.equals("6f6b")) {
                return;
            }
            ClientManager.send(response);
        }
        catch (DecoderException e) {
            throw new RuntimeException(e);
        }
        finally {
            ClientManager.remove();
        }
    }
}

