package com.aote.webmeter.tools.iot.onenet;

import com.af.plugins.HttpAsyncConnectionPoolUtil;
import com.af.plugins.HttpConnectionPoolUtil;
import com.af.plugins.RestTools;
import com.aote.webmeter.enums.OnenetApiEnum;
import com.aote.webmeter.enums.WebmeterPropertiesIOTEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import lombok.SneakyThrows;
import org.apache.http.client.methods.HttpPost;
import org.apache.log4j.Logger;
import org.json.JSONObject;

/**
 * @ClassName: IntelliJ IDEA
 * @Author: 林
 * @Date: 2022/5/31 10:13
 * @Description:
 */
public class OnenetMQTTRestTools {

    private static final Logger LOGGER = Logger.getLogger(OnenetRestTools.class);

    /**
     * 注册设备
     * @param params
     * @return
     */
    @SneakyThrows
    public static JSONObject createDevice(JSONObject params,String key) {
        //指定请求路径
        String path = OnenetApiEnum.MQTTRegister_URL.getValue();
        //设置请求头
        JSONObject headers = getHeader(key);
        //发送请求
        JSONObject result = new JSONObject(HttpConnectionPoolUtil.request(path,
                params.toString(),
                headers.toString(),
                new HttpPost()
        ));
        return result;
    }

    /**
     * 删除设备
     * @param deviceId
     * @return
     */
    @SneakyThrows
    public static JSONObject deleteDevice(String deviceId,String key) {
        //指定请求路径
        String path = OnenetApiEnum.DEVICE_URL.getValue() + "/" + deviceId;
        //设置请求头
        JSONObject headers = getHeader(key);
        //发送请求
        JSONObject result = new JSONObject(RestTools.delete(path, null, headers));
        return result;
    }

    /**
     * 发送命令
     * @param deviceId
     * @param timeout
     * @param content
     * @return
     */
    @SneakyThrows
    public static JSONObject writeDeviceRes(String deviceId,  String timeout, JSONObject content,String key) {
        JSONObject params = new JSONObject();
        params.put("device_id", deviceId);
        params.put("timeout", "86400");
        //指定请求路径
        String path = RestTools.formatURL(OnenetApiEnum.MQTTCOMMAND_URL.getValue(), params);
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        //发送请求
        LOGGER.debug("请求的地址："+ path);
        LOGGER.debug("请求头："+ headers);
        LOGGER.debug("请求体："+ content);
        HttpAsyncConnectionPoolUtil.request(path,
                content.toString(),
                headers.toString(),
                new HttpPost());
        return new JSONObject().put("errno",0);
    }

    @SneakyThrows
    public static JSONObject writeDeviceRes2(String imei, JSONObject content ) {
        JSONObject params = new JSONObject();
        params.put("topic", "hskj/hscq/"+imei);
        //指定请求路径
        String path = RestTools.formatURL(OnenetApiEnum.MQTTCOMMAND_URL2.getValue(), params);
        //设置请求头
        JSONObject headers = new JSONObject();
        headers.put("api-key", WebMeterInfo.getString(WebmeterPropertiesIOTEnum.ONE_NET_APIKEY));
        //发送请求
        LOGGER.debug("请求的地址："+ path);
        LOGGER.debug("请求头："+ headers);
        LOGGER.debug("请求体："+ content);
        HttpAsyncConnectionPoolUtil.request(path,
                content.toString(),
                headers.toString(),
                new HttpPost());
        return new JSONObject().put("errno",0);
    }

    private static JSONObject getHeader(String key) throws Exception{
        JSONObject headers = new JSONObject();
        headers.put("Authorization",getMQTTToken.assembleToken(key));
        return headers;
    }

}
