package com.aote.webmeter.tools;

import com.aote.rs.mapper.WebException;
import org.json.JSONObject;

import java.math.BigDecimal;

/**
 * 基础组件工具
 *
 * @author Mr.river
 */
public class Util {
    /**
     * Logic封装异常抛出
     */
    public static void error(JSONObject param) {
        int status = param.getInt("status");
        String msg = param.getString("msg");
        throw new WebException(status, msg);
    }

    /**
     * 转换一个值为正确的BigDecimal类型
     * 注：org.json:20200518 中JSONObject的getBigDecimal()方法有精度问题，
     * 需要先转换为String类型，再转换为BigDecimal
     *
     * @param value 值
     * @return BigDecimal类型
     */
    public static BigDecimal convertBigDecimal(Object value) {
        return new BigDecimal(String.valueOf(value));
    }

    /**
     * 获取正确的价格版本号
     * @param priceVersion 原始的价格版本号
     * @param maxValue 版本号最大值
     * @return 正确的价格版本号(0-255)
     */
    public static int getPriceVersion(Object priceVersion, Integer maxValue){
        int priceVersionValue = Integer.parseInt(priceVersion.toString());
        return priceVersionValue % maxValue == 0 ? maxValue : priceVersionValue % maxValue;
    }
    public static int getPriceVersion(Object priceVersion){
        return getPriceVersion(priceVersion, 255);
    }
}
