package com.aote.webmeter.socket.core.channel.impl;

import com.aote.webmeter.socket.core.channel.AbstractChannelHandler;
import com.aote.webmeter.socket.core.client.ClientManager;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteBufChannelHandler extends AbstractChannelHandler<ByteBuf> {

    private final Logger LOGGER = LoggerFactory.getLogger(ByteBufChannelHandler.class);

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, ByteBuf message) {
        LOGGER.debug("channelId:" + ctx.channel().id() + ", 收到消息");
        String response = runBusiness(message, ctx.channel().remoteAddress().toString());
        try {
            ClientManager.send(response);
        } catch (DecoderException e) {
            throw new RuntimeException(e);
        } finally {
            message.release();
        }
    }
}
