package com.aote.webmeter.socket.core.channel;

import com.af.plugins.ConvertTools;
import com.aote.logic.LogicServer;
import com.aote.webmeter.socket.SocketServerManager;
import com.aote.webmeter.socket.config.SocketConfigItem;
import com.aote.webmeter.socket.core.client.ClientManager;
import com.aote.webmeter.tools.tcp.TcpTools;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.net.InetSocketAddress;
import java.util.Arrays;

public abstract class AbstractChannelHandler<T> extends SimpleChannelInboundHandler<T> {

    private final Logger LOGGER = LoggerFactory.getLogger(AbstractChannelHandler.class);

    @Override
    protected abstract void channelRead0(ChannelHandlerContext ctx, T msg);

    protected String runBusiness(ByteBuf content, String remoteAddress) {
        SocketConfigItem configItem = ClientManager.getConfig();
        byte[] data = new byte[content.readableBytes()];
        content.readBytes(data);
        LOGGER.debug("数据原始体：{}", Arrays.toString(data));
        String realData;
        try {
            switch (configItem.getDecodeType()) {
                default: {
                    realData = ConvertTools.bytesToStr(data);
                    break;
                }
                case HEX: {
                    realData = ConvertTools.byteToHexStr(data);
                    break;
                }
            }
        } catch (Exception e) {
            LOGGER.error("数据解析失败：", e);
            return "6f6b";
        }

        LOGGER.debug("服务端收到信息：" + realData);

        LogicServer logicServer = SocketServerManager.applicationContext.getBean(LogicServer.class);

        try {
            JSONObject params = new JSONObject();
            params.put("value", realData);
            params.put("address", remoteAddress);
            // 调用实际执行具体业务的logic
            return logicServer.run(configItem.getLogicName(), params).toString();
        } catch (Exception e){
            LOGGER.error("业务处理失败", e);
            throw e;
        }
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        String channelId = ctx.channel().id().asLongText();
        LOGGER.debug("成功建立连接,channelId：{}", channelId);
        String port = String.valueOf(((InetSocketAddress) ctx.channel().localAddress()).getPort());
        SocketConfigItem configItem = SocketServerManager.getSocketConfigItemByPort(port);
        ClientManager.add(new ChannelData(configItem, ctx.channel()));
        super.channelActive(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        try {
            ClientManager.remove();
            ctx.close();
        } catch (Exception e) {
            LOGGER.error("关闭通道时发生异常", e);
        }
        super.channelInactive(ctx);
    }
}
