package com.aote.webmeter.service;

import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/**
 * IOT-设备告警策略模块帮助类
 */
public class DeviceAlarmStrategyHelper {

    private static final Map<String, Map<String, String>> alarmItemMap;

    static {
        alarmItemMap = new HashMap<>(5);

        Map<String, String> deviceCommonMap = new LinkedHashMap<>(1);
        deviceCommonMap.put("loseContactDay", "失联天数");
        alarmItemMap.put("deviceCommonMap", deviceCommonMap);

        Map<String, String> meterCommonMap = new LinkedHashMap<>(1);
        meterCommonMap.put("loseContactDay", "失联天数");
        alarmItemMap.put("meterCommonMap", meterCommonMap);

        Map<String, String> t_meteread_map = new LinkedHashMap<>(5);
        t_meteread_map.put("f_jval", "表端剩余金额");
        t_meteread_map.put("f_batterylevel", "电压");
        t_meteread_map.put("f_signal", "信号强度");
        t_meteread_map.put("flowmetertemperature", "温度");
        t_meteread_map.put("flowmeterpressure", "压力");
        t_meteread_map.put("f_magneticInterference", "磁干扰");
        t_meteread_map.put("f_alarmShutValve", "报警关阀");
        t_meteread_map.put("f_cycleShutValue", "周期关阀");
        t_meteread_map.put("f_arrearsShutValue", "欠费关阀");
        t_meteread_map.put("f_gasShutValue", "未用气关阀");
        t_meteread_map.put("f_overCurrentProtection", "过流保护关阀");
        t_meteread_map.put("f_LowLithiumBattery", "外部低电");
        t_meteread_map.put("f_LostLithiumBattery", "外部掉电");
        t_meteread_map.put("f_LowLithiumBattery2", "内部低电");
        t_meteread_map.put("f_timesException", "采样时钟异常");
        t_meteread_map.put("f_die_meter", "死表");
        t_meteread_map.put("f_die_meter_2", "死表2");
        t_meteread_map.put("f_LackOfGasFlag", "欠量");
        t_meteread_map.put("f_wireCloseValveState", "无线关阀");
        t_meteread_map.put("f_leakageFlag", "关阀走气");
        t_meteread_map.put("f_gas_leakage", "燃气泄露");
        t_meteread_map.put("f_valve_exception", "阀门直通");
        t_meteread_map.put("f_SplitAlarm", "拆表报警");
        t_meteread_map.put("f_valve_state", "阀门报警");
        t_meteread_map.put("f_abnormal_flow", "计量模块异常");
        t_meteread_map.put("forceSafeCheckFlag", "强制安检状态");
        t_meteread_map.put("forceSraptFlag", "强制报废状态");
        alarmItemMap.put("t_meteread", t_meteread_map);

        Map<String, String> t_pressure_monitor_read_map = new LinkedHashMap<>(10);
        t_pressure_monitor_read_map.put("f_hsp", "管道气体的相对压力(Kpa)");
        t_pressure_monitor_read_map.put("f_hst", "管道气体的温度(℃)");
        t_pressure_monitor_read_map.put("f_hsdy", "传感器电池电压(V)");
        t_pressure_monitor_read_map.put("f_hsdl", "传感器电池电量(%)");
        t_pressure_monitor_read_map.put("f_hstv", "太阳能电池电压(V)");
        t_pressure_monitor_read_map.put("f_hsta", "太阳能电池电流(mA)");
        t_pressure_monitor_read_map.put("f_hstt", "太阳能电池温度(℃)");
        t_pressure_monitor_read_map.put("f_hsdv", "直流供电电池电压(V)");
        t_pressure_monitor_read_map.put("f_hsda", "直流供电电池电流(mA)");
        t_pressure_monitor_read_map.put("f_hsdt", "直流供电电池温度(℃)");
        alarmItemMap.put("t_pressure_monitor_read", t_pressure_monitor_read_map);

        Map<String, String> t_pressure_transmitters_read_map = new LinkedHashMap<>(6);
        t_pressure_transmitters_read_map.put("flowmeterpressure", "压力值");
        t_pressure_transmitters_read_map.put("flowmetertemperature", "温度值");
        t_pressure_transmitters_read_map.put("f_highpressur", "压力量程高");
        t_pressure_transmitters_read_map.put("f_lowpressure", "压力量程低");
        t_pressure_transmitters_read_map.put("f_hightemperature", "温度量程高");
        t_pressure_transmitters_read_map.put("f_lowtemperature", "温度量程低");
        alarmItemMap.put("t_pressure_transmitters_read", t_pressure_transmitters_read_map);

        Map<String, String> t_wireless_detector_read_map = new LinkedHashMap<>(1);
        alarmItemMap.put("t_wireless_detector_read", t_wireless_detector_read_map);

        Map<String, String> t_t_wei_ge_read_map = new LinkedHashMap<>(1);
        t_t_wei_ge_read_map.put("flowmeterPressure", "压力");
        alarmItemMap.put("t_wei_ge_read", t_t_wei_ge_read_map);
    }

    public static JSONArray getAlarmItems(String tableName) {
        Map<String, String> itemMap = alarmItemMap.get(tableName);
        JSONArray result = new JSONArray(itemMap.size());
        itemMap.forEach((key, value) -> {
            JSONObject item = new JSONObject();
            item.put("label", value);
            item.put("value", key);
            result.put(item);
        });
        return result;
    }

    public static String getAlarmItem(String tableName, String alarmItemValue) {
        Map<String, String> itemMap = alarmItemMap.get(tableName);
        for (Map.Entry<String, String> entry : itemMap.entrySet()) {
            if (entry.getKey().equals(alarmItemValue)) {
                return entry.getValue();
            }
        }
        return alarmItemValue;
    }
}
