package com.aote.webmeter.mq;

import com.aote.redis.RedisUtil;
import com.aote.rs.LogicService;
import com.aote.rs.mapper.WebException;
import org.apache.log4j.Logger;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyContext;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.consumer.listener.MessageListenerConcurrently;
import org.apache.rocketmq.common.message.MessageExt;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.nio.charset.StandardCharsets;
import java.util.List;

/**
 * Iot请求消费监听
 */
public class IOTMessageListener implements MessageListenerConcurrently {
    /**
     * 日志对象
     */
    private static final Logger LOGGER = Logger.getLogger(IOTMessageListener.class);
    private static final RedisUtil redisUtil = RedisUtil.getInstance();
    @Autowired
    private LogicService logicService;

    @Override
    public ConsumeConcurrentlyStatus consumeMessage(List<MessageExt> msgs, ConsumeConcurrentlyContext context) {
        for (MessageExt msg : msgs) {
            String logicName = msg.getTags();
            String body = new String(msg.getBody(), StandardCharsets.UTF_8);
            try {
                //消费Logic请求
                JSONObject bodyObj = new JSONObject(body);
                LOGGER.info("mq：" + bodyObj);
                if (bodyObj.has("deviceId")) {
                    String deviceId = bodyObj.getString("deviceId");
                    redisUtil.lock(deviceId, 5, 30, () -> runLogic(logicName, body));
                } else {
                    runLogic(logicName, body);
                }
            } catch (WebException e) {
                //由于锁占用，业务降级处理
                runLogic(logicName + "LowerRank", body);
            } catch (Exception e) {
                LOGGER.error("【" + logicName + "】出现异常：", e);
            }
        }
        // 直接认为成功消费
        return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
    }

    private void runLogic(String logicName, String data) {
        try {
            logicService.xtSave(logicName, data);
        } catch (Exception e) {
            LOGGER.error("【" + logicName + "】出现异常：", e);
        }
    }
}
