package com.aote.webmeter.tools.iot.aep;

import com.aote.webmeter.tools.WebMeterInfo;
import com.ctg.ag.sdk.biz.AepDeviceCommandClient;
import com.ctg.ag.sdk.biz.AepDeviceCommandLwmProfileClient;
import com.ctg.ag.sdk.biz.AepDeviceManagementClient;
import com.ctg.ag.sdk.biz.AepMqSubClient;
import com.ctg.ag.sdk.core.constant.Scheme;

/**
 * 客户端实例工厂
 * @author 物联网小组
 */
public class ClientFactory {

    /**
     * 获取MQ消息订阅管理客户端
     */
    public static AepMqSubClient getAepMqSubClient(){
        return AepMqSubClient.newClient().scheme(Scheme.HTTPS)
                .scheme(Scheme.HTTPS)
                .appKey(WebMeterInfo.getString("appKey"))
                .appSecret(WebMeterInfo.getString("appSecret")).build();
    }

    /**
     * 获取设备管理客户端
     */
    public static AepDeviceManagementClient getAepDeviceManagementClient(){
        //创建设备管理客户端
        return AepDeviceManagementClient.newClient()
                .scheme(Scheme.HTTPS)
                .appKey(WebMeterInfo.getString("appKey"))
                .appSecret(WebMeterInfo.getString("appSecret")).build();
    }

    /**
     * 获取指令管理客户端
     */
    public static AepDeviceCommandClient getAepDeviceCommandClient(){
        return AepDeviceCommandClient.newClient()
                .scheme(Scheme.HTTPS)
                .appKey(WebMeterInfo.getString("appKey"))
                .appSecret(WebMeterInfo.getString("appSecret")).build();
    }

    /**
     * 获取指令(profile类型)管理客户端
     */
    public static AepDeviceCommandLwmProfileClient getAepDeviceCommandLwmProfileClient(){
        return AepDeviceCommandLwmProfileClient.newClient()
                .scheme(Scheme.HTTPS)
                .appKey(WebMeterInfo.getString("appKey"))
                .appSecret(WebMeterInfo.getString("appSecret")).build();
    }
}
