package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 阀控类型
 * @author Mr.river
 */
public enum ValveControlTypeEnum {
    //开阀
    OPEN_VALVE(1),
    //关阀
    CLOSE_VALVE(0);

    private final Integer value;

    ValveControlTypeEnum(Integer value) {
        this.value = value;
    }

    @JsonCreator
    public static ValveControlTypeEnum toType(Integer value) {
        return Stream.of(ValveControlTypeEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(Integer value){
        return toType(value) != null;
    }

    @JsonValue
    public Integer getValue(){
        return value;
    }
}
