package com.aote.webmeter.enums;

/**
 * IOT平台 通用错误码
 *
 * @author Mr.river
 */
public enum IOTExceptionCodeEnum implements ExceptionEnum {
    //平台鉴权异常
    AUTHENTICATION_FAIL(
            "EI1",
            "平台鉴权失败",
            "请检查telecomAPIKey及telecomSecret是否配置正确"
    ),
    //移动平台解密回调数据异常
    ONENET_DECODE_CALLBACK_FAIL(
            "EI2",
            "解密回调数据失败",
            "请检查EncodingAESKey是否配置正确"
    );

    private final String code;
    private final String name;
    private final String message;

    IOTExceptionCodeEnum(String code, String name, String message) {
        this.code = code;
        this.name = name;
        this.message = message;
    }


    @Override
    public String getCode() {
        return code;
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getMessage() {
        return message;
    }
}
