package com.aote.webmeter.common.template.saveInstruct;

import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SaveInstructParam;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplate;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.result.SaveInstructTemplateResult;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

/**
 * 保存指令的基础模板
 * @author Mr.river
 */
@Template
public class BasicSaveInstructTemplate extends AbstractTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(BasicSaveInstructTemplate.class);

    /**
     * 指令类型
     */
    protected InstructTypeEnum type;
    /**
     * 表档案ID
     */
    protected String userId;
    /**
     * 指令内容
     */
    protected JSONObject content;
    /**
     * 指令副类型
     */
    protected String title;
    /**
     * 气表品牌别名
     */
    protected String alias;
    /**
     * 操作人
     */
    protected InstructInputtorEnum inputtor;
    /**
     * 指令对应业务记录ID
     */
    protected String dataId;
    /**
     * 模块名称，默认通过定时器注入
     */
    protected String moduleName;
    /**
     * 指令管理
     */
    protected final InstructManage instructManage;
    /**
     * 表档案数据库操作
     */
    protected final UserFilesDao userFilesDao;
    /**
     * 收费数据-数据库操作
     */
    protected final SaleDataDao saleDataDao;
    /**
     * 换表数据-数据库操作
     */
    protected final ChangeMeterDataDao changeMeterDataDao;

    protected BasicSaveInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao){
        this.instructManage = instructManage;
        this.userFilesDao = userFilesDao;
        this.saleDataDao = saleDataDao;
        this.changeMeterDataDao = changeMeterDataDao;
    }


    public static class Builder extends AbstractTemplateBuilder{
        private final BasicSaveInstructTemplate template;

        public Builder(InstructTypeEnum type, String userId) {
            template = SpringBeanUtil.getBean(BasicSaveInstructTemplate.class);
            template.type = type;
            template.userId = userId;
        }

        @Override
        public BasicSaveInstructTemplate build() {
            template.inputtor = Optional.ofNullable(template.inputtor)
                    .orElse(InstructInputtorEnum.SYSTEM_DEFAULT);
            return template;
        }

        public Builder content(JSONObject content){
            template.content = content;
            return this;
        }

        public Builder title(String title){
            template.title = title;
            return this;
        }

        public Builder alias(String alias){
            template.alias = alias;
            return this;
        }

        public Builder inputtor(InstructInputtorEnum inputtor){
            template.inputtor = inputtor;
            return this;
        }

        public Builder dataId(String dataId) {
            template.dataId = dataId;
            return this;
        }

        public Builder moduleName(String moduleName){
            template.moduleName = moduleName;
            return this;
        }
    }

    @Override
    protected void beforeExec() {

    }

    @Override
    public SaveInstructTemplateResult exec() {
        beforeExec();
        if(Optional.ofNullable(moduleName).isPresent()){
            //设置模块名
            WebMeterInfo.setModuleName(moduleName);
        }
        LOGGER.info("----------表编号：{}开始通过模板保存{}指令--------", userId, type.getValue());
        //保存指令
        SaveInstructParam param = new SaveInstructParam.Builder(userId, type)
                .alias(alias)
                .title(title)
                .inputtor(inputtor)
                .contentData(content)
                .dataId(dataId)
                .build();
        String instructId = instructManage.save(param);
        LOGGER.info("通过模板保存{}指令成功，ID:{}",type.getValue(),instructId);
        afterExec();
        return new SaveInstructTemplateResult(instructId);
    }

    @Override
    protected void afterExec() {

    }
}
