package com.aote.webmeter.common.dto;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.utils.DataDeserializerBigDecimal;
import com.aote.webmeter.common.utils.SerializerBigDecimal;
import com.aote.webmeter.enums.business.SaleTypeEnum;
import com.aote.webmeter.enums.business.SettlementTypeEnum;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.json.JSONObject;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 查询待生成指令的充值数据-Result
 * 包含以下SQL
 * getGasRecharge@sql
 *
 * @author Mr.river
 */
@EqualsAndHashCode(callSuper = true)
@Data
public class GetRechargeDataDto extends GetInstructMetaDataDto {
    /**
     * 业务记录ID
     */
    private String id;
    /**
     * 旧业务记录ID
     */
    private String f_old_sell_id;
    /**
     * 表档案ID
     */
    private String userId;
    /**
     * 表档案编号
     */
    private String f_user_id;
    /**
     * 表号
     */
    private String f_meternumber;
    /**
     * 卡号
     */
    private String f_card_id;
    /**
     * 充值金额
     */
    @JsonDeserialize(using = DataDeserializerBigDecimal.class)
    @JsonSerialize(using = SerializerBigDecimal.class)
    private BigDecimal payValue;
    /**
     * 充值气量
     */
    @JsonDeserialize(using = DataDeserializerBigDecimal.class)
    @JsonSerialize(using = SerializerBigDecimal.class)
    private BigDecimal payGasValue;
    /**
     * 充值次数
     */
    private Integer f_times;
    /**
     * 总购金额
     */
    @JsonDeserialize(using = DataDeserializerBigDecimal.class)
    @JsonSerialize(using = SerializerBigDecimal.class)
    private BigDecimal total;
    /**
     * 总购气量
     */
    @JsonDeserialize(using = DataDeserializerBigDecimal.class)
    @JsonSerialize(using = SerializerBigDecimal.class)
    private BigDecimal totalGas;
    /**
     * 结算方式
     */
    private SettlementTypeEnum f_collection_type;
    /**
     * 气表型号
     */
    private String f_meter_style;
    /**
     * 收费类型
     */
    private SaleTypeEnum type;
    /**
     * 气价ID
     */
    private Integer stairid;
    /**
     * 阶梯周期
     */
    private Integer f_stairmonths;
    /**
     * 阶梯开始时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date start_date;
    /**
     * 价格生效时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date f_perform_date;

    private GetRechargeDataDto(){

    }

    public static class Builder {
        private final GetRechargeDataDto dto;

        public Builder(JSONObject getRechargeData) {
            dto = JsonHelper.toParse(getRechargeData, GetRechargeDataDto.class);
        }

        public GetRechargeDataDto build() {
            return dto;
        }
    }
}
