package com.aote.webmeter.common.template.saveInstruct;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.dto.GetOpenAccountDataDto;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.pour.SaveTemplatePour;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.OpenAccountStateEnum;
import com.aote.webmeter.enums.business.SaleTypeEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.aote.webmeter.tools.SpringBeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Optional;

/**
 * 保存开户指令模板
 * @author Mr.river
 */
@Template
public class SaveOpenAccountInstructTemplate extends BasicSaveInstructTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveOpenAccountInstructTemplate.class);

    /**
     * 查询待开户的档案数据-Result
     */
    private GetOpenAccountDataDto dto;
    /**
     * 调用保存指令模板时注入业务
     */
    private SaveTemplatePour saveTemplatePour;
    /**
     * 是否更新充值业务记录，默认false，用于将第一笔充值作为开户的情况
     */
    private Boolean isSellUpdate;


    protected SaveOpenAccountInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao){
        super(instructManage,userFilesDao,saleDataDao, changeMeterDataDao);
    }


    public static class Builder extends AbstractTemplateBuilder {
        private final SaveOpenAccountInstructTemplate template;

        public Builder(GetOpenAccountDataDto dto, SaveTemplatePour saveTemplatePour) {
            template = SpringBeanUtil.getBean(SaveOpenAccountInstructTemplate.class);
            template.dto = dto;
            template.saveTemplatePour = saveTemplatePour;
        }

        @Override
        public SaveOpenAccountInstructTemplate build() {
            template.isSellUpdate = Optional.ofNullable(template.isSellUpdate).orElse(false);
            return template;
        }

        public Builder moduleName(String moduleName){
            template.moduleName = moduleName;
            return this;
        }

        public Builder isSellUpdate(Boolean isSellUpdate){
            template.isSellUpdate = isSellUpdate;
            return this;
        }
    }

    @Override
    protected void beforeExec() {
        super.userId = dto.getUserId();
        super.type = InstructTypeEnum.OpenAccount;
        super.content = JsonHelper.toJSON(saveTemplatePour.run(dto));
        super.inputtor = InstructInputtorEnum.SYSTEM_FILES_LIFE_CYCLE;
        //设置指令标题和数据标识
        if(isSellUpdate){
            super.title = "开户充值";
            super.dataId = dto.getSellid();
        } else {
            super.title = "开户建档";
            super.dataId = dto.getUserId();
        }
    }

    @Override
    protected void afterExec() {
        //更新表具开户状态
        userFilesDao.updateMeterOpenAccountState(dto.getUserId(), OpenAccountStateEnum.READY_ACCOUNT);
        if(isSellUpdate){
            SaleTypeEnum typeEnum = dto.getType();
            //更新充值记录
            if(typeEnum == SaleTypeEnum.CHARGE){
                saleDataDao.updateSellingGasSyncState(dto.getSellid());
            } else if(typeEnum == SaleTypeEnum.REPLACE_METER_ADD_VOLUME || typeEnum == SaleTypeEnum.ADD_FEE){
                saleDataDao.updateSupplyGasSyncState(dto.getSellid());
            } else {
                throw new WebmeterException(BusinessExceptionCodeEnum.INVALID_RECHARGE_SOURCE_TYPE);
            }
        }
    }
}
