package com.aote.webmeter.common.modules.nbiot;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.modules.AbstractRunInstruct;
import com.aote.webmeter.common.modules.nbiot.param.ChangeMeterParams;
import com.aote.webmeter.common.modules.nbiot.param.OpenAccountParams;
import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.common.template.result.RunInstructTemplateResult;
import com.aote.webmeter.enums.business.IOTDockingModeEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.tools.iot.DeviceManagementTools;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.aote.webmeter.tools.iot.onenet.OnenetRestTools;
import org.json.JSONObject;

import java.util.Optional;

/**
 * NB-IOT平台物联网表保存指令
 *
 * @author Mr.river
 */
public abstract class NbIotRunInstruct implements AbstractRunInstruct {

    /**
     * 表档案数据库操作
     */
    protected final UserFilesDao userFilesDao;

    protected NbIotRunInstruct(UserFilesDao userFilesDao) {
        this.userFilesDao = userFilesDao;
    }

    @Override
    public RunTemplatePour runOpenAccount() {
        return (getInstructDto, templatePourExtraParams) -> {
            OpenAccountParams content = JsonHelper.toParse(new JSONObject(getInstructDto.getF_instruct_content()), OpenAccountParams.class);
            JSONObject requestResult;
            IOTDockingModeEnum dockingModeEnum = getInstructDto.getF_iot_type();
            if(dockingModeEnum == IOTDockingModeEnum.TELECOM){
                IotCommonTools.setIsAep(content.getIsAep().getValue());
                requestResult = DeviceManagementTools.regDevice(content.getImei(), getInstructDto.getF_meternumber());
            } else if(dockingModeEnum == IOTDockingModeEnum.ONENET){
                JSONObject params = new JSONObject();
                params.put("title",getInstructDto.getF_meternumber());
                params.put("mydevice",getInstructDto.getF_meternumber());
                params.put("protocol","NBCoAP");
                requestResult = OnenetRestTools.createDevice(params,content.getImei(),"000000000000000");
            } else {
                requestResult = new JSONObject();
                requestResult.put("code",-1);
                requestResult.put("msg","注册时收到未知的平台类型：" + dockingModeEnum.getValue());
            }
            int code = requestResult.getInt("code");
            RunInstructTemplateResult.Builder resultBuilder;
            if(code == 0){
                //更新设备号
                String deviceId = requestResult.getString("msg");
                userFilesDao.updateMeterDeviceId(getInstructDto.getF_meternumber(), deviceId);
                resultBuilder = new RunInstructTemplateResult.Builder()
                        .state(InstructStateEnum.SUCCESSFUL);
            } else {
                resultBuilder = new RunInstructTemplateResult.Builder()
                        .state(InstructStateEnum.FAILED)
                        .receiveMsg(requestResult.getString("msg"));
            }
            return resultBuilder.build();
        };
    }

    @Override
    public RunTemplatePour runChangeMeter() {
        return (getInstructDto, templatePourExtraParams) -> {
            ChangeMeterParams content = JsonHelper.toParse(new JSONObject(getInstructDto.getF_instruct_content()), ChangeMeterParams.class);
            JSONObject requestResult;
            if(Optional.ofNullable(content.getDeviceId()).isPresent()){
                IOTDockingModeEnum dockingModeEnum = getInstructDto.getF_iot_type();
                if(dockingModeEnum == IOTDockingModeEnum.TELECOM){
                    IotCommonTools.setIsAep(content.getIsAep().getValue());
                    requestResult = DeviceManagementTools.cancelDevice(content.getDeviceId());
                } else if(dockingModeEnum == IOTDockingModeEnum.ONENET){
                    requestResult = OnenetRestTools.deleteDevice(content.getDeviceId());
                } else {
                    requestResult = new JSONObject();
                    requestResult.put("code",-1);
                    requestResult.put("msg","注销时收到未知的平台类型：" + dockingModeEnum.getValue());
                }
            } else {
                requestResult = new JSONObject();
                requestResult.put("code",-1);
                requestResult.put("msg","设备ID为null");
            }
            int code = requestResult.getInt("code");
            RunInstructTemplateResult.Builder resultBuilder;
            if(code == 0){
                resultBuilder = new RunInstructTemplateResult.Builder()
                        .state(InstructStateEnum.SUCCESSFUL);
            } else {
                resultBuilder = new RunInstructTemplateResult.Builder()
                        .state(InstructStateEnum.FAILED);
            }
            return resultBuilder.receiveMsg(requestResult.getString("msg")).build();
        };
    }
}
