package com.aote.webmeter.common.dto;

import com.aote.util.JsonHelper;
import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.business.IOTDockingModeEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.MeterTableStateEnum;
import com.aote.webmeter.exception.WebmeterException;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import org.json.JSONObject;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;
import java.util.Optional;

/**
 * 查询指定条件的表具待发送指令-Result
 * 包含以下SQL
 * getInstruct@sql
 * yinGuangGetInstruct@sql
 * syncGetInstruct@sql
 * yinGuangSyncGetInstruct@sql
 *
 * @author Mr.river
 */
@Data
public class GetInstructDto {
    /**
     * ID
     */
    private String id;
    /**
     * 表档案ID
     */
    private String userId;
    /**
     * 表档案编号
     */
    private String f_user_id;
    /**
     * 表档案ID
     */
    private String f_userfiles_id;
    /**
     * 户档案ID
     */
    private String f_userinfo_id;
    /**
     * 设备品牌别名
     */
    private String f_alias;
    /**
     * 操作人
     */
    private String f_inputtor;
    /**
     * 表档案状态
     */
    private MeterTableStateEnum f_table_state;
    /**
     * 设备唯一标识
     */
    private String f_device_id;
    /**
     * IMEI号
     */
    private String f_imei;
    /**
     * 物联网平台类型
     */
    private IOTDockingModeEnum f_iot_type;
    /**
     * 设备厂家
     */
    private String f_manufacturers;
    /**
     * 表号
     */
    private String f_meternumber;
    /**
     * 指令类型
     */
    private InstructTypeEnum f_instruct_type;
    /**
     * 指令副类型
     */
    private String f_instruct_title;
    /**
     * 指令内容
     */
    private String f_instruct_content;
    /**
     * 指令生成时间
     */
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date f_instruct_date;
    /**
     * 指令状态
     */
    private InstructStateEnum f_instruct_state;

    private GetInstructDto(){

    }

    public static class Builder {
        private final GetInstructDto dto;

        public Builder(JSONObject getInstructData) {
            dto = JsonHelper.toParse(getInstructData, GetInstructDto.class);
            dto.userId = Optional.ofNullable(dto.getF_userfiles_id())
                    .orElseGet(()-> Optional.ofNullable(dto.getF_user_id())
                            .orElseThrow(()->new WebmeterException(BusinessExceptionCodeEnum.USER_ID_NOT_FIND)));
        }

        public GetInstructDto build() {
            return dto;
        }
    }
}
