-- 公共SQL：生成充值指令（附带气价信息，适用V3）
-- 必选参数
-- f_meter_brand：表具品牌别名

SELECT
    -- 业务记录ID
    sell.id,
    -- 旧业务记录ID
    sell.f_old_sell_id,
    -- 表档案ID
    sell.userid,
    -- 表档案编号
    u.f_user_id,
    -- 表号
    u.f_meternumber,
    -- 卡号
    NVL(u.f_card_id, u.f_meternumber) f_card_id,
    -- 充值金额
    sell.payvalue,
    -- 充值气量
    sell.paygasvalue,
    -- 充值次数
    sell.f_times,
    -- 总购金额
    sell.total,
    -- 总购气量
    sell.totalgas,
    -- 结算类型（按金额，按气量）
    g.f_collection_type,
    -- 气表型号
    m.f_meter_style,
    -- 气价方案ID
    sp.id  stairid,
    -- 阶梯开始时间
    NVL(sp.f_stair_start_date, sp.f_perform_date) start_date,
    -- 价格生效时间
    sp.f_perform_date,
    -- 阶梯周期（月）
    NVL(sp.f_stairmonths, 1)                      f_stairmonths,
    -- 充值类型
    sell.type
FROM (
    SELECT f.id             id,
           f.f_userfiles_id userid,
           f.f_preamount    payvalue,
           f.f_pregas       paygasvalue,
           f.f_times        f_times,
           f.id             f_old_sell_id,
           f.f_total_fee    total,
           f.f_total_gas    totalgas,
           case f.f_type
               when '物联网补费' then '补费'
               when '物联网扣费' then '扣费'
               else '换表补气'
               end           type
    FROM t_fillgas f
    WHERE f.f_state = '有效'
      AND (f.f_sendsuccess = '未同步' or f.f_sendsuccess is null)
    UNION ALL
    SELECT s.id             id,
           s.f_userfiles_id userid,
           s.f_preamount    payvalue,
           s.f_pregas       paygasvalue,
           s.f_times        f_times,
           s.f_old_sell_id,
           s.f_total_fee    total,
           s.f_total_gas    totalgas,
           case s.f_type
               when '物联网收费' then '充值'
               when '退费' then '退费'
               else '充值/退费'
               end           type
    FROM t_sellinggas s
    WHERE s.f_state = '有效'
      AND s.f_type IN ('物联网收费', '退费')
      AND (s.f_sendsuccess = '未同步' or s.f_sendsuccess is null)
    UNION ALL
    SELECT s.id             id,
           s.f_userfiles_id userid,
           s.f_preamount    payvalue,
           s.f_pregas       paygasvalue,
           s.f_times        f_times,
           s.f_old_sell_id,
           s.f_total_fee    total,
           s.f_total_gas    totalgas,
           '冲正'             type
    FROM t_sellinggas s
        LEFT JOIN t_sellinggas tsp ON s.f_old_sell_id = tsp.id
    WHERE s.f_state = '撤销'
      AND (s.f_sendsuccess = '未同步' or s.f_sendsuccess is null)
      AND tsp.f_sendsuccess = '成功'
    ) sell
    LEFT JOIN t_userfiles u ON u.f_userfiles_id = sell.userid
    LEFT JOIN t_gasbrand g ON u.f_gasbrand_id = g.id
    LEFT JOIN t_stairprice sp ON sp.f_price_id = u.f_price_id and u.f_filialeid = sp.f_filialeid
    LEFT JOIN t_gasmodel m ON u.f_gasmodel_id = m.id
WHERE g.f_alias = '{f_meter_brand}'
  AND g.f_calculation = '表端结算'
  AND u.f_sendsuccess = '成功'
  AND u.f_table_state = '正常'
  AND sp.f_state = '有效'
  AND sysdate <= sp.f_end_date
ORDER BY sell.f_times
