/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.template.saveInstruct;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.basic.manage.InstructManage;
import com.aote.webmeter.common.dao.ChangeMeterDataDao;
import com.aote.webmeter.common.dao.SaleDataDao;
import com.aote.webmeter.common.dao.UserFilesDao;
import com.aote.webmeter.common.dto.GetChangeMeterDataDto;
import com.aote.webmeter.common.stereotype.Template;
import com.aote.webmeter.common.template.AbstractTemplateBuilder;
import com.aote.webmeter.common.template.pour.SaveTemplatePour;
import com.aote.webmeter.common.template.saveInstruct.BasicSaveInstructTemplate;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.enums.business.OpenAccountStateEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Template
public class SaveChangeMeterInstructTemplate
extends BasicSaveInstructTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveChangeMeterInstructTemplate.class);
    private GetChangeMeterDataDto dto;
    private SaveTemplatePour saveTemplatePour;

    protected SaveChangeMeterInstructTemplate(InstructManage instructManage, UserFilesDao userFilesDao, SaleDataDao saleDataDao, ChangeMeterDataDao changeMeterDataDao) {
        super(instructManage, userFilesDao, saleDataDao, changeMeterDataDao);
    }

    @Override
    protected void beforeExec() {
        this.userId = this.dto.getF_userfiles_id_old();
        this.type = InstructTypeEnum.ChangeMeter;
        this.content = JsonHelper.toJSON((Object)this.saveTemplatePour.run(this.dto));
        this.inputtor = InstructInputtorEnum.SYSTEM_FILES_LIFE_CYCLE;
        this.title = "\u6362\u8868/\u6ce8\u9500";
    }

    @Override
    protected void afterExec() {
        this.userFilesDao.updateMeterOpenAccountState(this.dto.getF_userfiles_id_old(), OpenAccountStateEnum.READY_ACCOUNT);
        this.changeMeterDataDao.updateChangeMeterSyncState(this.dto.getId());
    }

    public static class Builder
    extends AbstractTemplateBuilder {
        private final SaveChangeMeterInstructTemplate template = SpringBeanUtil.getBean(SaveChangeMeterInstructTemplate.class);

        public Builder(GetChangeMeterDataDto dto, SaveTemplatePour saveTemplatePour) {
            this.template.dto = dto;
            this.template.saveTemplatePour = saveTemplatePour;
        }

        @Override
        public SaveChangeMeterInstructTemplate build() {
            return this.template;
        }

        public Builder moduleName(String moduleName) {
            this.template.moduleName = moduleName;
            return this;
        }
    }
}

