/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.dao;

import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.enums.DataSourceTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.Map;

public abstract class AbstractDao {
    protected String formatUpdateSql(String tableName, Map<String, Object> params, Condition condition, boolean isLockOptimize) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("\tUPDATE ").append(tableName);
        if (isLockOptimize && WebMeterInfo.getDataSourceTypeEnum() == DataSourceTypeEnum.SQLSERVER) {
            sqlBuilder.append(" WITH (READPAST)");
        }
        sqlBuilder.append(" SET");
        params.forEach((key, value) -> {
            String realValue = String.valueOf(value);
            realValue = !String.valueOf(value).startsWith("@") ? "'" + value + "'" : realValue.substring(1);
            sqlBuilder.append("\n\t  ").append((String)key).append(" = ").append(realValue).append(",");
        });
        sqlBuilder.deleteCharAt(sqlBuilder.length() - 1);
        sqlBuilder.append("\n\tWHERE ").append(condition.getValue());
        return sqlBuilder.toString();
    }

    protected String formatUpdateSql(String tableName, Map<String, Object> params, Condition condition) {
        return this.formatUpdateSql(tableName, params, condition, false);
    }
}

