/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.modules;

import com.aote.util.JsonHelper;
import com.aote.webmeter.common.dto.GetChangeMeterDataDto;
import com.aote.webmeter.common.dto.GetOpenAccountDataDto;
import com.aote.webmeter.common.template.pour.RunTemplatePour;
import com.aote.webmeter.common.template.pour.SaveTemplatePour;
import com.aote.webmeter.common.template.pour.result.SaveInstructResult;
import com.aote.webmeter.enums.business.IOTDockingModeEnum;
import com.aote.webmeter.enums.business.TelecomDockingModeEnum;
import com.aote.webmeter.modules.AbstractWebmeter;
import com.aote.webmeter.tools.iot.DeviceManagementTools;
import com.aote.webmeter.tools.iot.IotCommonTools;
import com.aote.webmeter.tools.iot.onenet.OnenetRestTools;
import java.io.IOException;
import java.util.Optional;
import org.json.JSONObject;

public abstract class AbstractNBWebmeter
implements AbstractWebmeter {
    @Override
    public SaveTemplatePour saveOpenAccount() {
        return dto -> {
            GetOpenAccountDataDto myDto = (GetOpenAccountDataDto)dto;
            OpenAccountParams result = new OpenAccountParams();
            result.imei = myDto.getF_imei();
            result.iotType = myDto.getF_iot_type();
            result.isAep = myDto.getF_terminal_id();
            return result;
        };
    }

    @Override
    public SaveTemplatePour saveChangeMeter() {
        return dto -> {
            GetChangeMeterDataDto myDto = (GetChangeMeterDataDto)dto;
            ChangeMeterParams result = new ChangeMeterParams();
            result.deviceId = myDto.getF_device_id();
            result.iotType = myDto.getF_iot_type();
            result.isAep = myDto.getF_terminal_id();
            return result;
        };
    }

    @Override
    public RunTemplatePour runOpenAccount() {
        return null;
    }

    @Override
    public RunTemplatePour runChangeMeter() {
        return (getInstructDto, templatePourExtraParams) -> {
            ChangeMeterParams content = (ChangeMeterParams)JsonHelper.toParse((JSONObject)new JSONObject(getInstructDto.getF_instruct_content()), ChangeMeterParams.class);
            if (Optional.ofNullable(content.deviceId).isPresent()) {
                int result;
                IOTDockingModeEnum dockingModeEnum = getInstructDto.getF_iot_type();
                if (dockingModeEnum == IOTDockingModeEnum.TELECOM) {
                    IotCommonTools.setIsAep(content.isAep.getValue());
                    try {
                        int result2 = DeviceManagementTools.cancelDevice(content.deviceId);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                } else if (dockingModeEnum == IOTDockingModeEnum.ONENET && (result = OnenetRestTools.deleteDevice(content.deviceId).getInt("errno")) == 3) {
                    result = 0;
                    String string = "\u8bbe\u5907\u4e0d\u5b58\u5728";
                }
            }
            return null;
        };
    }

    static class ChangeMeterParams
    extends SaveInstructResult {
        String deviceId;
        IOTDockingModeEnum iotType;
        TelecomDockingModeEnum isAep;

        ChangeMeterParams() {
        }
    }

    static class OpenAccountParams
    extends SaveInstructResult {
        String imei;
        IOTDockingModeEnum iotType;
        TelecomDockingModeEnum isAep;

        OpenAccountParams() {
        }
    }
}

