/*
 * Decompiled with CFR 0.152.
 */
package com.aote.webmeter.common.dao;

import com.af.plugins.DateTools;
import com.aote.sql.SqlServer;
import com.aote.util.JsonHelper;
import com.aote.webmeter.common.basic.manage.param.instructmanage.SetInstructStateParam;
import com.aote.webmeter.common.basic.manage.result.GetWaitInstructResult;
import com.aote.webmeter.common.dao.AbstractDao;
import com.aote.webmeter.common.dto.GetInstructDto;
import com.aote.webmeter.common.utils.Condition;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import java.util.HashMap;
import java.util.Optional;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={Exception.class})
@Component
public class InstructDao
extends AbstractDao {
    private final SqlServer sqlServer;

    public InstructDao(SqlServer sqlServer) {
        this.sqlServer = sqlServer;
    }

    public GetWaitInstructResult getWaitInstructs(Condition condition) {
        String sqlName;
        SaleVersionEnum saleName = WebMeterInfo.getSaleNameEnum();
        String userIdColumn = null;
        switch (saleName) {
            case SILVER_LIGHT: 
            case SILVER_LIGHT2: {
                sqlName = "yinGuangGetInstruct";
                break;
            }
            default: {
                userIdColumn = CompatTools.getUserFilesId();
                sqlName = "getInstruct";
            }
        }
        JSONObject sqlParams = new JSONObject();
        sqlParams.put("userIdColumn", (Object)userIdColumn);
        sqlParams.put("condition", (Object)condition);
        JSONArray instructs = this.sqlServer.query(sqlName, sqlParams);
        int nums = instructs.length();
        return new GetWaitInstructResult(nums, JsonHelper.toParseList((JSONArray)instructs, GetInstructDto.class));
    }

    public void updateRedundancyValveControlInstruct(String userId) {
        String userIdColumn = CompatTools.getUserFilesId();
        String tableName = CompatTools.getInstructTableName();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("f_instruct_state", InstructStateEnum.CANCELED.getValue());
        this.sqlServer.run(this.formatUpdateSql(tableName, params, Condition.build().eq("f_instruct_state", InstructStateEnum.READY.getValue()).and().eq(userIdColumn, userId).and().eq("f_instruct_type", InstructTypeEnum.ValveControl.getValue()), true), new Object[]{userIdColumn, userId});
    }

    public void updateRedundancyOtherInstruct(String userId, InstructTypeEnum instructTypeEnum, String instructTitle) {
        String userIdColumn = CompatTools.getUserFilesId();
        String tableName = CompatTools.getInstructTableName();
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("f_instruct_state", InstructStateEnum.CANCELED.getValue());
        this.sqlServer.run(this.formatUpdateSql(tableName, params, Condition.build().eq("f_instruct_state", InstructStateEnum.READY.getValue()).and().eq(userIdColumn, userId).and().eq("f_instruct_type", instructTypeEnum.getValue()).and().asFirst(Condition.build().isNull("f_instruct_title").or().eq("f_instruct_title", instructTitle)), true), new Object[]{userIdColumn, userId, instructTypeEnum.getValue(), instructTitle});
    }

    public int updateInstructState(SetInstructStateParam param) {
        String sendDate = null;
        String callBackDate = null;
        String now = DateTools.getNow2();
        switch (param.getState()) {
            case SUCCESSFUL: 
            case FAILED: {
                sendDate = "@isnull(f_send_date,'" + now + "'),";
                callBackDate = now;
                break;
            }
            case ALREADY_SENT: {
                sendDate = now;
                break;
            }
            case TIME_OUT: {
                callBackDate = now;
                break;
            }
        }
        sendDate = Optional.ofNullable(sendDate).orElse("@f_send_date");
        callBackDate = Optional.ofNullable(callBackDate).orElse("@f_callback_date");
        String tableName = CompatTools.getInstructTableName();
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put("f_instruct_state", param.getState().getValue());
        params.put("f_receive_state", param.getReceiveMsg());
        params.put("f_send_date", sendDate);
        params.put("f_callback_date", callBackDate);
        params.put("f_instruct_meta_data", param.getMetaData());
        params.put("f_commandId", param.getSyncCommandId());
        return this.sqlServer.runSQL(this.formatUpdateSql(tableName, params, param.getCondition(), true));
    }
}

