package com.aote.webmeter.exception;

import com.aote.webmeter.enums.BusinessExceptionCodeEnum;

/**
 * 档案数据异常回调默认处理
 *
 * @author Mr.river
 */
public class DefaultUserFilesDataCallback implements DataExceptionCallback {

    /**
     * 数据存在多条的处理
     */
    @Override
    public void call(String condition, int length){
        if(length == 0) {
            throw new WebmeterException(BusinessExceptionCodeEnum.USER_FILE_NOT_FIND, condition);
        } else {
            throw new WebmeterException(BusinessExceptionCodeEnum.USER_FILE_FIND_MULTIPLE, condition);
        }
    }
}
