package com.aote.webmeter.exception;

import org.json.JSONArray;

/**
 * 异常回调处理
 *
 * @author Mr.river
 */
@FunctionalInterface
public interface DataExceptionCallback {
    /**
     * 检查数据并处理
     * @param data 数据集合
     * @param condition 条件表达式
     */
    default void checkData(JSONArray data, String condition){
        if(data.length() == 0 || data.length() > 0){
            call(condition, data.length());
        }
    }

    /**
     * 数据异常时的回调函数
     * @param condition 条件表达式
     * @param length 数据集合长度
     */
    void call(String condition,int length);
}
