package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 指令状态
 * @author Mr.river
 */
public enum InstructStateEnum {
    //待发送
    READY("待发送",-1,"未知"),
    //执行成功
    SUCCESSFUL("执行成功",0,"成功"),
    //执行失败
    FAILED("执行失败",1,"失败"),
    //已发送
    ALREADY_SENT("已发送",2,"等待表端执行"),
    //响应超时
    TIME_OUT("响应超时",3,"表端响应超时"),
    //忽略冗余
    CANCELED("忽略冗余",4,"自动取消"),
    //已延迟
    DELAYED("已延迟",5,"延迟发送"),
    //无响应
    NO_RESPONSE("无响应",6,"未收到表端响应");


    private final String value;

    private final Integer code;

    private final String defaultReceiveMsg;

    InstructStateEnum(String value,Integer code,String defaultReceiveMsg) {
        this.value = value;
        this.code = code;
        this.defaultReceiveMsg = defaultReceiveMsg;
    }

    @JsonCreator
    public static InstructStateEnum toType(String value) {
        return Stream.of(InstructStateEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static InstructStateEnum toType(Integer code) {
        return Stream.of(InstructStateEnum.values())
                .filter(p -> p.code.equals(code))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    public static boolean is(Integer code){
        return toType(code) != null;
    }

    @JsonValue
    public String getValue(){
        return value;
    }

    public int getCode() { return code; }

    public String getReceiveMsg() {return defaultReceiveMsg; }
}
