package com.aote.webmeter.enums.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import java.util.stream.Stream;

/**
 * 物联网表服务 操作人角色类型
 * @author Mr.river
 */
public enum InstructInputtorEnum {
    //系统生成
    SYSTEM_DEFAULT("系统生成"),
    //系统必需
    SYSTEM_REQUISITE("系统必需"),
    //系统充值
    CHARGE("系统充值"),
    //系统档案流程
    SYSTEM_FILES_LIFE_CYCLE("系统档案流程"),
    //其他
    OTHER("其他");

    private String value;

    InstructInputtorEnum(String value) {
        this.value = value;
    }

    @JsonCreator
    public static InstructInputtorEnum toType(String value) {
        return Stream.of(InstructInputtorEnum.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(InstructInputtorEnum.OTHER.setValue(value));
    }

    public static boolean is(String value){
        return toType(value) != null;
    }

    @JsonValue
    public String getValue(){
        return value;
    }

    private InstructInputtorEnum setValue(String value){
        this.value = value;
        return this;
    }
}
