package com.aote.webmeter.common.template.builder.impl.saveInstruct;

import com.aote.webmeter.common.basic.pour.PourSaveLogic;
import com.aote.webmeter.common.template.builder.SaveInstructTemplateBuilder;
import com.aote.webmeter.common.template.member.saveInstruct.SaveGasRechargeTemplate;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import lombok.Getter;
import org.json.JSONObject;

/**
 * 保存充值指令模板-构造器
 * @author Mr.river
 */
@Getter
public class SaveGasRechargeTemplateBuilder extends SaveInstructTemplateBuilder {

    protected SaveGasRechargeTemplateBuilder(JSONObject entity, PourSaveLogic pourSaveLogic) {
        super(entity, InstructTypeEnum.GasRecharge, pourSaveLogic);
        this.setInputtor(InstructInputtorEnum.CHARGE);
        this.setTitle(entity.getString("type"));
        this.setDataId(String.valueOf(entity.get("id")));
    }

    public static SaveGasRechargeTemplateBuilder create(JSONObject entity, PourSaveLogic pourSaveLogic) {
        return new SaveGasRechargeTemplateBuilder(entity, pourSaveLogic);
    }

    @Override
    public SaveGasRechargeTemplate build() {
        return SpringBeanUtil.getBean(SaveGasRechargeTemplate.class,this);
    }
}
