package com.aote.webmeter.common.template.builder.impl.runInstruct;

import com.aote.webmeter.common.basic.pour.PourRunLogic;
import com.aote.webmeter.common.basic.pour.PourRunLogicCall;
import com.aote.webmeter.common.template.builder.TemplateBuilder;
import com.aote.webmeter.common.template.member.runInstruct.RunInstructTemplate;
import com.aote.webmeter.common.entity.InstructEntity;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.tools.SpringBeanUtil;
import lombok.Getter;
import org.json.JSONObject;

/**
 * 执行指令模板-构造器
 */
@Getter
public class RunInstructTemplateBuilder extends TemplateBuilder {

    private InstructEntity instructEntity;
    private PourRunLogic pourRunLogic;
    private PourRunLogicCall pourRunLogicCall;
    private String moduleName;
    private JSONObject pourCallLogicParams;

    public static RunInstructTemplateBuilder create(InstructEntity instructEntity, PourRunLogic pourRunLogic) {
        return new RunInstructTemplateBuilder(instructEntity, pourRunLogic);
    }

    @Override
    public RunInstructTemplate build() { return SpringBeanUtil.getBean(RunInstructTemplate.class,this); }

    protected RunInstructTemplateBuilder(InstructEntity instructEntity, PourRunLogic pourRunLogic){
        super();
        this.setInstructEntity(instructEntity);
        this.setPourRunLogic(pourRunLogic);
    }

    /**
     * @param instructEntity 指令实体
     */
    public void setInstructEntity(InstructEntity instructEntity) {
        this.instructEntity = instructEntity;
    }

    /**
     * @param pourRunLogic 执行指令所需的注入逻辑接口
     * @apiNote 该接口用于扩展实现执行指令的逻辑，run方法接收原始指令数据，
     * 返回一个RunInstructTemplateResult作为执行指令的结果
     * @see PourRunLogic#run(InstructEntity)
     * @see com.aote.webmeter.common.template.result.RunInstructTemplateResult
     */
    public void setPourRunLogic(PourRunLogic pourRunLogic) {
        this.pourRunLogic = pourRunLogic;
    }

    public RunInstructTemplateBuilder setModuleName(String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    /**
     * @param pourRunLogicCall 执行指令所需的注入回调逻辑接口
     * @apiNote 该接口用于扩展实现执行指令后回调触发的逻辑，call方法接收指令的状态，指令实体以及自定义JSON格式参数
     * @see PourRunLogicCall#call(InstructStateEnum, InstructEntity, JSONObject)
     */
    public RunInstructTemplateBuilder setPourRunLogicCall(PourRunLogicCall pourRunLogicCall) {
        this.pourRunLogicCall = pourRunLogicCall;
        return this;
    }

    /**
     * @param pourCallLogicParams 执行指令注入回调逻辑接口的自定义参数
     * @apiNote 该参数可以用于执行指令注入回调逻辑接口中，作为传入的通用参数使用
     */
    public RunInstructTemplateBuilder setPourCallLogicParams(JSONObject pourCallLogicParams) {
        this.pourCallLogicParams = pourCallLogicParams;
        return this;
    }
}
