package com.aote.webmeter.common.dao;

import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.SaleVersionEnum;
import com.aote.webmeter.exception.DataExceptionCallback;
import com.aote.webmeter.exception.DefaultUserFilesDataCallback;
import com.aote.webmeter.tools.CompatTools;
import com.aote.webmeter.tools.WebMeterInfo;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.Optional;

/**
 * 表档案数据库操作
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class UserFilesDao {
    private final SqlServer sqlServer;

    public UserFilesDao(SqlServer sqlServer) {
        this.sqlServer = sqlServer;
    }

    /**
     * 创建指令时获取档案信息
     * @param userId 表档案ID
     * @param alias 表品牌别名
     * @param callback 数据异常处理回调
     * @return 档案信息
     * @throws Exception 查询异常
     */
    public JSONArray getMeterInfoByCreateInstruct(String userId, String alias, DataExceptionCallback callback) throws Exception {
        //获取条件表达式
        String condition = CompatTools.getBasicCondition(userId);
        //获取营收系统版本名
        SaleVersionEnum saleName = WebMeterInfo.getSaleNameEnum();
        //获取SQL名称
        String sqlName;
        switch (saleName){
            case SILVER_LIGHT:
                sqlName = "yinGuangGetMeterInfoBySaveInstruct";
                break;
            case SILVER_LIGHT2:
                sqlName = "yinGuangGetMeterInfo2BySaveInstruct";
                break;
            default:
                sqlName = "getMeterInfoBySaveInstruct";
                break;
        }
        //查询用户档案，获取生成指令所需的信息
        JSONObject sqlParams = new JSONObject();
        sqlParams.put("f_meter_brand", alias);
        sqlParams.put("condition", condition);
        JSONArray result = sqlServer.query(sqlName,sqlParams);
        //检查数据
        Optional.ofNullable(callback).orElseGet(DefaultUserFilesDataCallback::new).checkData(result, condition);
        return result;
    }
}
