package com.aote.webmeter.common.dao;

import com.aote.sql.SqlServer;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.CompatTools;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

/**
 * 指令数据库操作
 */
@Transactional(rollbackFor=Exception.class)
@Component
public class InstructDao {
    private final SqlServer sqlServer;

    public InstructDao(SqlServer sqlServer) {
        this.sqlServer = sqlServer;
    }

    /**
     * 更新冗余的阀控指令
     * @param userId 表档案ID
     */
    public void updateRedundancyValveControlInstruct(String userId){
        String tableName = CompatTools.getInstructTableName();
        String userIdColumn = CompatTools.getUserFilesId();
        sqlServer.run("UPDATE {} SET f_instruct_state='忽略冗余'\n" +
                "WHERE F_INSTRUCT_STATE = '待发送'\n" +
                "AND {} = '{}'\n" +
                "AND F_INSTRUCT_TYPE = '阀门控制'",tableName,userIdColumn,userId);
    }

    /**
     * 更新冗余的其他指令
     * @param userId 表档案ID
     */
    public void updateRedundancyOtherInstruct(String userId, InstructTypeEnum instructTypeEnum, String instructTitle){
        String tableName = CompatTools.getInstructTableName();
        String userIdColumn = CompatTools.getUserFilesId();
        sqlServer.run("UPDATE {} SET f_instruct_state='忽略冗余'\n" +
                "WHERE F_INSTRUCT_STATE = '待发送'\n" +
                "AND {} = '{}'\n" +
                "AND F_INSTRUCT_TYPE = '{}'\n" +
                "AND (F_INSTRUCT_TITLE IS NULL OR F_INSTRUCT_TITLE = '{}')",
                tableName,userIdColumn, userId,instructTypeEnum.getValue(),instructTitle);
    }

    public void updateInstructState(String condition, InstructTypeEnum instructTypeEnum, String instructTitle){
        String tableName = CompatTools.getInstructTableName();
        String userIdColumn = CompatTools.getUserFilesId();
//        sqlServer.run("UPDATE {} SET \n" +
//                        "F_INSTRUCT_STATE = '{}', \n" +
//                        "F_RECEIVE_STATE = '{}', \n" +
//                        "{}" +
//                        "{}" +
//                        "F_INSTRUCT_META_DATA = {}, \n" +
//                        "F_COMMANDID = {} \n" +
//                        "WHERE {} ",
//                tableName,userIdColumn, userId,instructTypeEnum.getValue(),instructTitle);
    }
}
