package com.aote.webmeter.common.basic.manage.param;

import com.aote.webmeter.enums.BusinessExceptionCodeEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.exception.WebmeterException;
import lombok.Getter;

import javax.validation.constraints.NotNull;
import java.util.Arrays;
import java.util.Optional;

/**
 * 设置指令状态参数
 * @author Mr.river
 */
@Getter
public class SetInstructStateParam {

    /**
     * 指令ID
     */
    private String id;
    /**
     * 指令标识
     */
    private String commandId;
    /**
     * 条件表达式
     */
    private String condition;
    /**
     * 指令状态
     */
    private InstructStateEnum state;
    /**
     * 指令元数据
     */
    private String metaData;
    /**
     * 指令响应信息
     */
    private String receiveMsg;
    /**
     * 需要保存的指令标识
     */
    private String syncCommandId;

    private SetInstructStateParam(){

    }

    public static class Builder {
        private final SetInstructStateParam param;

        public Builder(@NotNull InstructStateEnum stateEnum) {
            param = new SetInstructStateParam();
            param.state = stateEnum;
        }

        public SetInstructStateParam build(){
            param.condition = Optional.ofNullable(param.id)
                    .map((value)-> "id = '" + value + "'")
                    .orElseGet(()-> Optional.ofNullable(param.commandId)
                            .map((value)-> "f_commandId = '"+ value +"'")
                            .orElseGet(()-> Optional.ofNullable(param.condition)
                                    .orElseThrow(()->{
                                        String[] array = new String[]{"id", "commandId", "condition"};
                                        return new WebmeterException(
                                                BusinessExceptionCodeEnum.BUSINESS_PARAMS_NOT_FIND,
                                                "构造\"SetInstructStateParam\"时以下参数之一不能为null："+ Arrays.toString(array));
                                    })
                            )
                    );
            return param;
        }

        public Builder id(String id){
            param.id = id;
            return this;
        }

        public Builder commandId(String commandId){
            param.commandId = commandId;
            return this;
        }

        public Builder condition(String condition){
            param.condition = condition;
            return this;
        }

        public Builder metaData(String metaData){
            param.metaData = metaData;
            return this;
        }

        public Builder receiveMsg(String receiveMsg){
            param.receiveMsg = receiveMsg;
            return this;
        }

        public Builder syncCommandId(String syncCommandId){
            param.syncCommandId = syncCommandId;
            return this;
        }
    }

    public String getReceiveMsg(){
        return Optional.ofNullable(receiveMsg).orElseGet(()->state.getReceiveMsg());
    }

    public String getMetaData(){
        return Optional.ofNullable(metaData)
                .map((value)-> "'" + value + "'")
                .orElse("isnull(f_instruct_meta_data,f_instruct_content)");
    }

    public String getSyncCommandId(){
        return Optional.ofNullable(syncCommandId)
                .map((value)-> "'" + value + "'")
                .orElse("isnull(f_commandId,id)");
    }

    public static void main(String[] args) {
        SetInstructStateParam param = new SetInstructStateParam.
                Builder(null).build();
        System.out.println(param.getCondition());
    }
}
