package com.aote.webmeter.common.basic.manage.param;

import com.af.plugins.DateTools;
import com.aote.webmeter.enums.WebmeterPropertiesEnum;
import com.aote.webmeter.enums.business.InstructInputtorEnum;
import com.aote.webmeter.enums.business.InstructStateEnum;
import com.aote.webmeter.enums.business.InstructTypeEnum;
import com.aote.webmeter.tools.WebMeterInfo;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Getter;
import org.json.JSONObject;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import java.util.Date;
import java.util.Optional;

/**
 * 保存指令参数
 * @author Mr.river
 */
@Getter
public class SaveInstructParam {

    /**
     * 指令类型
     */
    private InstructTypeEnum f_instruct_type;
    /**
     * 指令副类型
     */
    private String f_instruct_title;
    /**
     * 指令状态
     */
    private InstructStateEnum f_instruct_state;
    /**
     * 指令响应信息
     */
    private String f_receive_state;
    /**
     * 指令内容
     */
    private String f_instruct_content;
    /**
     * 指令对应业务记录ID
     */
    private String f_data_id;
    /**
     * 指令对应的抄表记录ID
     */
    private String f_meteread_id;
    /**
     * 气表品牌别名
     */
    private String f_alias;
    /**
     * 操作人
     */
    private InstructInputtorEnum f_inputtor;
    /**
     * 指令备注
     */
    private String f_info;
    @DateTimeFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss",timezone="GMT+8")
    private Date f_instruct_date;

    private SaveInstructParam(){

    }

    public static class Builder {
        private final SaveInstructParam param;

        public Builder(@NotNull InstructTypeEnum typeEnum) {
            param = new SaveInstructParam();
            param.f_instruct_type = typeEnum;
        }

        public SaveInstructParam build(){
            return param;
        }

        public Builder title(String title){
            param.f_instruct_title = title;
            return this;
        }

        public Builder state(InstructStateEnum stateEnum){
            param.f_instruct_state = stateEnum;
            return this;
        }

        public Builder contentData(String contentData){
            param.f_instruct_content = contentData;
            return this;
        }

        public Builder dataId(String dataId){
            param.f_data_id = dataId;
            return this;
        }

        public Builder metereadId(String metereadId){
            param.f_meteread_id = metereadId;
            return this;
        }

        public Builder alias(String alias){
            param.f_alias = alias;
            return this;
        }

        public Builder inputtor(InstructInputtorEnum inputtor){
            param.f_inputtor = inputtor;
            return this;
        }

        public Builder info(String info){
            param.f_info = info;
            return this;
        }
    }

    public String getF_alias(){
        return Optional.ofNullable(f_alias).orElseGet(() -> WebMeterInfo.getString(WebmeterPropertiesEnum.METER_ALIAS.getValue()));
    }

    public String getF_instruct_title(){
        return Optional.ofNullable(f_instruct_title).orElseGet(() -> f_instruct_type.getValue());
    }

    public InstructStateEnum getF_instruct_state(){
        return Optional.ofNullable(f_instruct_state).orElse(InstructStateEnum.READY);
    }

    public String getF_instruct_content(){
        return Optional.ofNullable(f_instruct_content).orElseGet(() -> new JSONObject().toString());
    }

    public InstructInputtorEnum getF_inputtor(){
        return Optional.ofNullable(f_inputtor).orElse(InstructInputtorEnum.SYSTEM_DEFAULT);
    }

    public Date getF_instruct_date(){
        return Optional.ofNullable(f_instruct_date).orElseGet(DateTools::getNow);
    }

    public String getF_receive_state(){
        return Optional.ofNullable(f_receive_state).orElseGet(()->f_instruct_state.getReceiveMsg());
    }
}
